/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.slf4j.Logger;

public abstract class BookProvider
implements class_2405 {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final Collector<ModonomiconLanguageProvider, ?, Object2ObjectOpenHashMap<String, ModonomiconLanguageProvider>> mapMaker = Collector.of(Object2ObjectOpenHashMap::new, (map, l) -> map.put((Object)l.locale(), l), (m1, m2) -> {
        m1.putAll((Map)m2);
        return m1;
    }, map -> {
        map.trim();
        return map;
    }, Collector.Characteristics.UNORDERED);
    protected final class_7784 packOutput;
    protected final ModonomiconLanguageProvider lang;
    protected final Map<String, ModonomiconLanguageProvider> translations;
    protected final Map<class_2960, BookModel> bookModels;
    protected final String modid;
    protected String bookId;
    protected BookContextHelper context;
    protected Map<String, String> defaultMacros;
    protected ConditionHelper conditionHelper;

    public BookProvider(String bookId, class_7784 packOutput, String modid, ModonomiconLanguageProvider defaultLang, ModonomiconLanguageProvider ... translations) {
        this.modid = modid;
        this.packOutput = packOutput;
        this.lang = defaultLang;
        this.bookModels = new Object2ObjectOpenHashMap();
        this.translations = (Map)Stream.concat(Arrays.stream(translations), Stream.of(defaultLang)).collect(mapMaker);
        this.bookId = bookId;
        this.context = new BookContextHelper(this.modid);
        this.defaultMacros = new Object2ObjectOpenHashMap();
        this.conditionHelper = new ConditionHelper();
    }

    protected ModonomiconLanguageProvider lang() {
        return this.lang;
    }

    protected ModonomiconLanguageProvider lang(String locale) {
        return this.translations.get(locale);
    }

    public String bookId() {
        return this.bookId;
    }

    protected BookContextHelper context() {
        return this.context;
    }

    protected ConditionHelper condition() {
        return this.conditionHelper;
    }

    protected abstract void registerDefaultMacros();

    protected abstract BookModel generateBook();

    protected void registerDefaultMacro(String macro, String value) {
        this.defaultMacros.put(macro, value);
    }

    protected Map<String, String> defaultMacros() {
        return this.defaultMacros;
    }

    protected void generate() {
        this.context.book(this.bookId);
        this.add(this.generateBook());
    }

    protected class_2960 modLoc(String name) {
        return new class_2960(this.modid, name);
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + bookModel.getId());
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }

    protected Path getPath(Path dataFolder, BookModel bookModel) {
        class_2960 id = bookModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(id.method_12832() + "/book.json");
    }

    protected Path getPath(Path dataFolder, BookCategoryModel bookCategoryModel) {
        class_2960 id = bookCategoryModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookCategoryModel.getBook().getId().method_12832()).resolve("categories").resolve(id.method_12832() + ".json");
    }

    protected Path getPath(Path dataFolder, BookCommandModel bookCommandModel) {
        class_2960 id = bookCommandModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookCommandModel.getBook().getId().method_12832()).resolve("commands").resolve(id.method_12832() + ".json");
    }

    protected Path getPath(Path dataFolder, BookEntryModel bookEntryModel) {
        class_2960 id = bookEntryModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookEntryModel.getCategory().getBook().getId().method_12832()).resolve("entries").resolve(id.method_12832() + ".json");
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Path dataFolder = this.packOutput.method_45972(class_7784.class_7490.field_39367);
        this.registerDefaultMacros();
        this.generate();
        for (BookModel bookModel : this.bookModels.values()) {
            Path bookPath = this.getPath(dataFolder, bookModel);
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookModel.toJson(), (Path)bookPath));
            for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                Path bookCategoryPath = this.getPath(dataFolder, bookCategoryModel);
                futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookCategoryModel.toJson(), (Path)bookCategoryPath));
                for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                    Path bookEntryPath = this.getPath(dataFolder, bookEntryModel);
                    futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookEntryModel.toJson(), (Path)bookEntryPath));
                }
            }
            for (BookCommandModel bookCommandModel : bookModel.getCommands()) {
                Path bookCommandPath = this.getPath(dataFolder, bookCommandModel);
                futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookCommandModel.toJson(), (Path)bookCommandPath));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "Books: " + this.modid;
    }
}

