/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BookCategoryModel {
    protected BookModel book;
    protected class_2960 id;
    protected String name;
    protected BookIconModel icon = BookIconModel.create((class_1935)ItemRegistry.MODONOMICON_PURPLE.get());
    protected int sortNumber = -1;
    protected class_2960 background = new class_2960(ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND);
    protected int backgroundWidth = 512;
    protected int backgroundHeight = 512;
    protected float backgroundTextureZoomMultiplier = 1.0f;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = new ArrayList<BookCategoryBackgroundParallaxLayer>();
    protected class_2960 entryTextures = new class_2960(ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES);
    protected List<BookEntryModel> entries = new ArrayList<BookEntryModel>();
    @Nullable
    protected BookConditionModel condition = null;
    protected boolean showCategoryButton = true;

    protected BookCategoryModel(class_2960 id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookCategoryModel create(class_2960 id, String name) {
        return new BookCategoryModel(id, name);
    }

    @Nullable
    public BookConditionModel getCondition() {
        return this.condition;
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }

    public List<BookEntryModel> getEntries() {
        return this.entries;
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.add("icon", (JsonElement)this.icon.toJson());
        json.addProperty("sort_number", (Number)this.sortNumber);
        json.addProperty("background", this.background.toString());
        json.addProperty("background_width", (Number)this.backgroundWidth);
        json.addProperty("background_height", (Number)this.backgroundHeight);
        json.addProperty("background_texture_zoom_multiplier", (Number)Float.valueOf(this.backgroundTextureZoomMultiplier));
        json.add("background_parallax_layers", (JsonElement)this.backgroundParallaxLayers.stream().map(layer -> (JsonElement)BookCategoryBackgroundParallaxLayer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, layer).get().orThrow()).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        json.addProperty("entry_textures", this.entryTextures.toString());
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson());
        }
        json.addProperty("show_category_button", Boolean.valueOf(this.showCategoryButton));
        return json;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BookIconModel getIcon() {
        return this.icon;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public class_2960 getEntryTextures() {
        return this.entryTextures;
    }

    public BookCategoryModel withIcon(BookIconModel icon) {
        this.icon = icon;
        return this;
    }

    public BookCategoryModel withIcon(class_2960 texture) {
        this.icon = BookIconModel.create(texture);
        return this;
    }

    public BookCategoryModel withIcon(class_2960 texture, int width, int height) {
        this.icon = BookIconModel.create(texture, width, height);
        return this;
    }

    public BookCategoryModel withIcon(class_1935 item) {
        this.icon = BookIconModel.create(item);
        return this;
    }

    public BookCategoryModel withSortNumber(int sortNumber) {
        this.sortNumber = sortNumber;
        return this;
    }

    public BookCategoryModel withBackground(class_2960 background) {
        this.background = background;
        return this;
    }

    public BookCategoryModel withBackgroundSize(int width, int height) {
        this.backgroundWidth = width;
        this.backgroundHeight = height;
        return this;
    }

    public BookCategoryModel withBackgroundTextureZoomMultiplier(float backgroundTextureZoomMultiplier) {
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayers(BookCategoryBackgroundParallaxLayer ... layers) {
        this.backgroundParallaxLayers.addAll(List.of(layers));
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(BookCategoryBackgroundParallaxLayer layer) {
        this.backgroundParallaxLayers.add(layer);
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(class_2960 layerTexture) {
        this.backgroundParallaxLayers.add(new BookCategoryBackgroundParallaxLayer(layerTexture));
        return this;
    }

    public BookCategoryModel withEntryTextures(class_2960 entryTextures) {
        this.entryTextures = entryTextures;
        return this;
    }

    public BookCategoryModel withEntries(List<BookEntryModel> entries) {
        entries.forEach(this::linkEntry);
        this.entries.addAll(entries);
        return this;
    }

    protected BookEntryModel linkEntry(BookEntryModel entry) {
        entry.category = this;
        if (!entry.id.method_12832().startsWith(this.id.method_12832())) {
            entry.id = new class_2960(entry.id.method_12836(), this.id.method_12832() + "/" + entry.id.method_12832());
        }
        return entry;
    }

    public BookCategoryModel withEntries(BookEntryModel ... entries) {
        return this.withEntries(List.of(entries));
    }

    public BookCategoryModel withEntry(BookEntryModel entry) {
        this.entries.add(this.linkEntry(entry));
        return this;
    }

    public BookCategoryModel withCondition(BookConditionModel condition) {
        this.condition = condition;
        return this;
    }

    public BookCategoryModel withShowCategoryButton(boolean showCategoryButton) {
        this.showCategoryButton = showCategoryButton;
        return this;
    }
}

