/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import net.minecraft.class_2561;

public class BookAndConditionModel
extends BookConditionModel {
    protected BookConditionModel[] children;

    protected BookAndConditionModel(BookConditionModel[] children, class_2561 tooltip, String tooltipString) {
        super(ModonomiconConstants.Data.Condition.AND, tooltip, tooltipString);
        this.children = children;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BookConditionModel[] getChildren() {
        return this.children;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonArray children = new JsonArray();
        for (BookConditionModel child : this.children) {
            children.add((JsonElement)child.toJson());
        }
        json.add("children", (JsonElement)children);
        return json;
    }

    public static final class Builder {
        private BookConditionModel[] children;
        private class_2561 tooltip;
        private String tooltipString;

        private Builder() {
        }

        public static Builder aBookAdvancementConditionModel() {
            return new Builder();
        }

        public BookConditionModel[] getChildren() {
            return this.children;
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }

        public String getTooltipString() {
            return this.tooltipString;
        }

        public Builder withChildren(BookConditionModel ... children) {
            this.children = children;
            return this;
        }

        public Builder withTooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder withTooltipString(String tooltipString) {
            this.tooltipString = tooltipString;
            return this;
        }

        public BookAndConditionModel build() {
            BookAndConditionModel model = new BookAndConditionModel(this.children, this.tooltip, this.tooltipString);
            return model;
        }
    }
}

