/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class Book {
    protected class_2960 id;
    protected String name;
    protected String tooltip;
    protected String creativeTab;
    protected class_2960 model;
    protected class_2960 bookOverviewTexture;
    protected class_2960 frameTexture;
    protected BookFrameOverlay topFrameOverlay;
    protected BookFrameOverlay bottomFrameOverlay;
    protected BookFrameOverlay leftFrameOverlay;
    protected BookFrameOverlay rightFrameOverlay;
    protected class_2960 bookContentTexture;
    protected class_2960 craftingTexture;
    protected class_2960 turnPageSound;
    protected ConcurrentMap<class_2960, BookCategory> categories;
    protected ConcurrentMap<class_2960, BookEntry> entries;
    protected ConcurrentMap<class_2960, BookCommand> commands;
    protected int defaultTitleColor;
    protected float categoryButtonIconScale;
    protected boolean autoAddReadConditions;
    protected boolean generateBookItem;
    @Nullable
    protected class_2960 customBookItem;
    protected class_2960 font;
    protected int bookTextOffsetX;
    protected int bookTextOffsetY;
    protected int bookTextOffsetWidth;
    protected int categoryButtonXOffset;
    protected int categoryButtonYOffset;
    protected int searchButtonXOffset;
    protected int searchButtonYOffset;
    protected int readAllButtonYOffset;
    protected boolean allowOpenBooksWithInvalidLinks;
    protected Supplier<class_1799> bookItem = Suppliers.memoize(() -> {
        if (this.customBookItem != null) {
            Triple<class_2960, Integer, class_2487> parsed = ItemStackUtil.parseItemStackString(this.customBookItem.toString());
            return ItemStackUtil.loadFromParsed(parsed);
        }
        class_1799 stack = new class_1799((class_1935)ItemRegistry.MODONOMICON.get());
        class_2487 tag = new class_2487();
        tag.method_10582("modonomicon:book_id", this.id.toString());
        stack.method_7980(tag);
        return stack;
    });

    public Book(class_2960 id, String name, String tooltip, class_2960 model, boolean generateBookItem, @Nullable class_2960 customBookItem, String creativeTab, class_2960 font, class_2960 bookOverviewTexture, class_2960 frameTexture, BookFrameOverlay topFrameOverlay, BookFrameOverlay bottomFrameOverlay, BookFrameOverlay leftFrameOverlay, BookFrameOverlay rightFrameOverlay, class_2960 bookContentTexture, class_2960 craftingTexture, class_2960 turnPageSound, int defaultTitleColor, float categoryButtonIconScale, boolean autoAddReadConditions, int bookTextOffsetX, int bookTextOffsetY, int bookTextOffsetWidth, int categoryButtonXOffset, int categoryButtonYOffset, int searchButtonXOffset, int searchButtonYOffset, int readAllButtonYOffset, boolean allowOpenBooksWithInvalidLinks) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
        this.model = model;
        this.generateBookItem = generateBookItem;
        this.customBookItem = customBookItem;
        this.creativeTab = creativeTab;
        this.bookOverviewTexture = bookOverviewTexture;
        this.font = font;
        this.frameTexture = frameTexture;
        this.topFrameOverlay = topFrameOverlay;
        this.bottomFrameOverlay = bottomFrameOverlay;
        this.leftFrameOverlay = leftFrameOverlay;
        this.rightFrameOverlay = rightFrameOverlay;
        this.bookContentTexture = bookContentTexture;
        this.craftingTexture = craftingTexture;
        this.turnPageSound = turnPageSound;
        this.defaultTitleColor = defaultTitleColor;
        this.categoryButtonIconScale = categoryButtonIconScale;
        this.autoAddReadConditions = autoAddReadConditions;
        this.categories = new ConcurrentHashMap<class_2960, BookCategory>();
        this.entries = new ConcurrentHashMap<class_2960, BookEntry>();
        this.commands = new ConcurrentHashMap<class_2960, BookCommand>();
        this.bookTextOffsetX = bookTextOffsetX;
        this.bookTextOffsetY = bookTextOffsetY;
        this.bookTextOffsetWidth = bookTextOffsetWidth;
        this.categoryButtonXOffset = categoryButtonXOffset;
        this.categoryButtonYOffset = categoryButtonYOffset;
        this.searchButtonXOffset = searchButtonXOffset;
        this.searchButtonYOffset = searchButtonYOffset;
        this.readAllButtonYOffset = readAllButtonYOffset;
        this.allowOpenBooksWithInvalidLinks = allowOpenBooksWithInvalidLinks;
    }

    public static Book fromJson(class_2960 id, JsonObject json) {
        String name = class_3518.method_15265((JsonObject)json, (String)"name");
        String tooltip = class_3518.method_15253((JsonObject)json, (String)"tooltip", (String)"");
        class_2960 model = new class_2960(class_3518.method_15253((JsonObject)json, (String)"model", (String)ModonomiconConstants.Data.Book.DEFAULT_MODEL));
        boolean generateBookItem = class_3518.method_15258((JsonObject)json, (String)"generate_book_item", (boolean)true);
        class_2960 customBookItem = json.has("custom_book_item") ? new class_2960(class_3518.method_15265((JsonObject)json, (String)"custom_book_item")) : null;
        String creativeTab = class_3518.method_15253((JsonObject)json, (String)"creative_tab", (String)"misc");
        class_2960 bookOverviewTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"book_overview_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE));
        class_2960 frameTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"frame_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_FRAME_TEXTURE));
        BookFrameOverlay topFrameOverlay = json.has("top_frame_overlay") ? BookFrameOverlay.fromJson(json.get("top_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_TOP_FRAME_OVERLAY;
        BookFrameOverlay bottomFrameOverlay = json.has("bottom_frame_overlay") ? BookFrameOverlay.fromJson(json.get("bottom_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_BOTTOM_FRAME_OVERLAY;
        BookFrameOverlay leftFrameOverlay = json.has("left_frame_overlay") ? BookFrameOverlay.fromJson(json.get("left_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_LEFT_FRAME_OVERLAY;
        BookFrameOverlay rightFrameOverlay = json.has("right_frame_overlay") ? BookFrameOverlay.fromJson(json.get("right_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_RIGHT_FRAME_OVERLAY;
        class_2960 font = new class_2960(class_3518.method_15253((JsonObject)json, (String)"font", (String)ModonomiconConstants.Data.Book.DEFAULT_FONT));
        class_2960 bookContentTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"book_content_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE));
        class_2960 craftingTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"crafting_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE));
        class_2960 turnPageSound = new class_2960(class_3518.method_15253((JsonObject)json, (String)"turn_page_sound", (String)ModonomiconConstants.Data.Book.DEFAULT_PAGE_TURN_SOUND));
        int defaultTitleColor = class_3518.method_15282((JsonObject)json, (String)"default_title_color", (int)0);
        float categoryButtonIconScale = class_3518.method_15277((JsonObject)json, (String)"category_button_icon_scale", (float)1.0f);
        boolean autoAddReadConditions = class_3518.method_15258((JsonObject)json, (String)"auto_add_read_conditions", (boolean)false);
        int bookTextOffsetX = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_x", (int)0);
        int bookTextOffsetY = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_y", (int)0);
        int bookTextOffsetWidth = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_width", (int)0);
        int categoryButtonXOffset = class_3518.method_15282((JsonObject)json, (String)"category_button_x_offset", (int)0);
        int categoryButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"category_button_y_offset", (int)0);
        int searchButtonXOffset = class_3518.method_15282((JsonObject)json, (String)"search_button_x_offset", (int)0);
        int searchButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"search_button_y_offset", (int)0);
        int readAllButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"read_all_button_y_offset", (int)0);
        boolean allowOpenBooksWithInvalidLinks = class_3518.method_15258((JsonObject)json, (String)"allow_open_book_with_invalid_links", (boolean)false);
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, allowOpenBooksWithInvalidLinks);
    }

    public static Book fromNetwork(class_2960 id, class_2540 buffer) {
        String name = buffer.method_19772();
        String tooltip = buffer.method_19772();
        class_2960 model = buffer.method_10810();
        boolean generateBookItem = buffer.readBoolean();
        class_2960 customBookItem = buffer.readBoolean() ? buffer.method_10810() : null;
        String creativeTab = buffer.method_19772();
        class_2960 font = buffer.method_10810();
        class_2960 bookOverviewTexture = buffer.method_10810();
        class_2960 frameTexture = buffer.method_10810();
        BookFrameOverlay topFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay bottomFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay leftFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay rightFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        class_2960 bookContentTexture = buffer.method_10810();
        class_2960 craftingTexture = buffer.method_10810();
        class_2960 turnPageSound = buffer.method_10810();
        int defaultTitleColor = buffer.readInt();
        float categoryButtonIconScale = buffer.readFloat();
        boolean autoAddReadConditions = buffer.readBoolean();
        short bookTextOffsetX = buffer.readShort();
        short bookTextOffsetY = buffer.readShort();
        short bookTextOffsetWidth = buffer.readShort();
        short categoryButtonXOffset = buffer.readShort();
        short categoryButtonYOffset = buffer.readShort();
        short searchButtonXOffset = buffer.readShort();
        short searchButtonYOffset = buffer.readShort();
        short readAllButtonYOffset = buffer.readShort();
        boolean allowOpenBooksWithInvalidLinks = buffer.readBoolean();
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, allowOpenBooksWithInvalidLinks);
    }

    public void build(class_1937 level) {
        for (BookCategory category : this.categories.values()) {
            for (BookEntry entry : category.getEntries().values()) {
                this.addEntry(entry);
            }
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.build(level, this);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
        for (BookCommand command : this.commands.values()) {
            command.build(this);
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(this.name);
        buffer.method_10814(this.tooltip);
        buffer.method_10812(this.model);
        buffer.writeBoolean(this.generateBookItem);
        buffer.writeBoolean(this.customBookItem != null);
        if (this.customBookItem != null) {
            buffer.method_10812(this.customBookItem);
        }
        buffer.method_10814(this.creativeTab);
        buffer.method_10812(this.font);
        buffer.method_10812(this.bookOverviewTexture);
        buffer.method_10812(this.frameTexture);
        this.topFrameOverlay.toNetwork(buffer);
        this.bottomFrameOverlay.toNetwork(buffer);
        this.leftFrameOverlay.toNetwork(buffer);
        this.rightFrameOverlay.toNetwork(buffer);
        buffer.method_10812(this.bookContentTexture);
        buffer.method_10812(this.craftingTexture);
        buffer.method_10812(this.turnPageSound);
        buffer.writeInt(this.defaultTitleColor);
        buffer.writeFloat(this.categoryButtonIconScale);
        buffer.writeBoolean(this.autoAddReadConditions);
        buffer.writeShort(this.bookTextOffsetX);
        buffer.writeShort(this.bookTextOffsetY);
        buffer.writeShort(this.bookTextOffsetWidth);
        buffer.writeShort(this.categoryButtonXOffset);
        buffer.writeShort(this.categoryButtonYOffset);
        buffer.writeShort(this.searchButtonXOffset);
        buffer.writeShort(this.searchButtonYOffset);
        buffer.writeShort(this.readAllButtonYOffset);
        buffer.writeBoolean(this.allowOpenBooksWithInvalidLinks);
    }

    public class_1799 getBookItem() {
        return this.bookItem.get();
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public class_2960 getTurnPageSound() {
        return this.turnPageSound;
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public float getCategoryButtonIconScale() {
        return this.categoryButtonIconScale;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void addCategory(BookCategory category) {
        this.categories.putIfAbsent(category.id, category);
    }

    public BookCategory getCategory(class_2960 id) {
        return (BookCategory)this.categories.get(id);
    }

    public Map<class_2960, BookCategory> getCategories() {
        return this.categories;
    }

    public List<BookCategory> getCategoriesSorted() {
        return this.categories.values().stream().sorted(Comparator.comparingInt(BookCategory::getSortNumber)).toList();
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(class_2960 id) {
        return (BookEntry)this.entries.get(id);
    }

    public Map<class_2960, BookEntry> getEntries() {
        return this.entries;
    }

    public void addCommand(BookCommand command) {
        this.commands.putIfAbsent(command.id, command);
    }

    public ConcurrentMap<class_2960, BookCommand> getCommands() {
        return this.commands;
    }

    public BookCommand getCommand(class_2960 id) {
        return (BookCommand)this.commands.get(id);
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public class_2960 getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public class_2960 getFont() {
        return this.font;
    }

    public class_2960 getFrameTexture() {
        return this.frameTexture;
    }

    public BookFrameOverlay getTopFrameOverlay() {
        return this.topFrameOverlay;
    }

    public BookFrameOverlay getBottomFrameOverlay() {
        return this.bottomFrameOverlay;
    }

    public BookFrameOverlay getLeftFrameOverlay() {
        return this.leftFrameOverlay;
    }

    public BookFrameOverlay getRightFrameOverlay() {
        return this.rightFrameOverlay;
    }

    @Nullable
    public class_2960 getCustomBookItem() {
        return this.customBookItem;
    }

    public class_2960 getCraftingTexture() {
        return this.craftingTexture;
    }

    public class_2960 getBookContentTexture() {
        return this.bookContentTexture;
    }

    public class_2960 getModel() {
        return this.model;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }

    public int getBookTextOffsetX() {
        return this.bookTextOffsetX;
    }

    public int getBookTextOffsetY() {
        return this.bookTextOffsetY;
    }

    public int getBookTextOffsetWidth() {
        return this.bookTextOffsetWidth;
    }

    public int getCategoryButtonXOffset() {
        return this.categoryButtonXOffset;
    }

    public int getCategoryButtonYOffset() {
        return this.categoryButtonYOffset;
    }

    public int getSearchButtonXOffset() {
        return this.searchButtonXOffset;
    }

    public int getSearchButtonYOffset() {
        return this.searchButtonYOffset;
    }

    public int getReadAllButtonYOffset() {
        return this.readAllButtonYOffset;
    }

    public boolean allowOpenBooksWithInvalidLinks() {
        return this.allowOpenBooksWithInvalidLinks;
    }
}

