/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BookCategory {
    protected class_2960 id;
    protected Book book;
    protected String name;
    protected BookIcon icon;
    protected int sortNumber;
    protected class_2960 background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected float backgroundTextureZoomMultiplier;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers;
    protected class_2960 entryTextures;
    protected ConcurrentMap<class_2960, BookEntry> entries;
    protected BookCondition condition;
    protected boolean showCategoryButton;

    public BookCategory(class_2960 id, String name, int sortNumber, BookCondition condition, boolean showCategoryButton, BookIcon icon, class_2960 background, int backgroundWidth, int backgroundHeight, float backgroundTextureZoomMultiplier, List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers, class_2960 entryTextures) {
        this.id = id;
        this.name = name;
        this.sortNumber = sortNumber;
        this.condition = condition;
        this.showCategoryButton = showCategoryButton;
        this.icon = icon;
        this.background = background;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        this.backgroundParallaxLayers = backgroundParallaxLayers;
        this.entryTextures = entryTextures;
        this.entries = new ConcurrentHashMap<class_2960, BookEntry>();
    }

    public static BookCategory fromJson(class_2960 id, JsonObject json) {
        String name = class_3518.method_15265((JsonObject)json, (String)"name");
        int sortNumber = class_3518.method_15282((JsonObject)json, (String)"sort_number", (int)-1);
        BookIcon icon = BookIcon.fromJson(json.get("icon"));
        class_2960 background = new class_2960(class_3518.method_15253((JsonObject)json, (String)"background", (String)ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND));
        int backgroundWidth = class_3518.method_15282((JsonObject)json, (String)"background_width", (int)512);
        int backgroundHeight = class_3518.method_15282((JsonObject)json, (String)"background_height", (int)512);
        float backgroundTextureZoomMultiplier = class_3518.method_15277((JsonObject)json, (String)"background_texture_zoom_multiplier", (float)1.0f);
        class_2960 entryTextures = new class_2960(class_3518.method_15253((JsonObject)json, (String)"entry_textures", (String)ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES));
        boolean showCategoryButton = class_3518.method_15258((JsonObject)json, (String)"show_category_button", (boolean)true);
        BookCondition condition = new BookNoneCondition();
        if (json.has("condition")) {
            condition = BookCondition.fromJson(json.getAsJsonObject("condition"));
        }
        List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = List.of();
        if (json.has("background_parallax_layers")) {
            backgroundParallaxLayers = BookCategoryBackgroundParallaxLayer.fromJson(json.getAsJsonArray("background_parallax_layers"));
        }
        return new BookCategory(id, name, sortNumber, condition, showCategoryButton, icon, background, backgroundWidth, backgroundHeight, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures);
    }

    public static BookCategory fromNetwork(class_2960 id, class_2540 buffer) {
        String name = buffer.method_19772();
        int sortNumber = buffer.readInt();
        BookIcon icon = BookIcon.fromNetwork(buffer);
        class_2960 background = buffer.method_10810();
        int backgroundWidth = buffer.method_10816();
        int backgroundHeight = buffer.method_10816();
        float backgroundTextureZoomMultiplier = buffer.readFloat();
        List backgroundParallaxLayers = buffer.method_34066(BookCategoryBackgroundParallaxLayer::fromNetwork);
        class_2960 entryTextures = buffer.method_10810();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        boolean showCategoryButton = buffer.readBoolean();
        return new BookCategory(id, name, sortNumber, condition, showCategoryButton, icon, background, backgroundWidth, backgroundHeight, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures);
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(this.name);
        buffer.writeInt(this.sortNumber);
        this.icon.toNetwork(buffer);
        buffer.method_10812(this.background);
        buffer.method_10804(this.backgroundWidth);
        buffer.method_10804(this.backgroundHeight);
        buffer.writeFloat(this.backgroundTextureZoomMultiplier);
        buffer.method_34062(this.backgroundParallaxLayers, (buf, layer) -> layer.toNetwork((class_2540)buf));
        buffer.method_10812(this.entryTextures);
        BookCondition.toNetwork(this.condition, buffer);
        buffer.writeBoolean(this.showCategoryButton);
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }

    public void build(class_1937 level, Book book) {
        this.book = book;
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            entry.build(level, this);
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            try {
                entry.prerenderMarkdown(textRenderer);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to render markdown in book '" + this.book.getId() + "' for entry '" + entry.getId() + "'", e);
            }
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getName() {
        return this.name;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public float getBackgroundTextureZoomMultiplier() {
        return this.backgroundTextureZoomMultiplier;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public class_2960 getEntryTextures() {
        return this.entryTextures;
    }

    public Map<class_2960, BookEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(class_2960 id) {
        return (BookEntry)this.entries.get(id);
    }

    public BookCondition getCondition() {
        return this.condition;
    }
}

