/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class BookIcon {
    private final class_1799 itemStack;
    private final class_2960 texture;
    private final int width;
    private final int height;

    public BookIcon(class_1799 stack) {
        this.itemStack = stack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    public BookIcon(class_2960 texture, int width, int height) {
        this.texture = texture;
        this.itemStack = class_1799.field_8037;
        this.width = width;
        this.height = height;
    }

    public static BookIcon fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return BookIcon.fromString(new class_2960(jsonElement.getAsString()));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("item")) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"item")));
            return new BookIcon(new class_1799((class_1935)item));
        }
        if (jsonObject.has("texture")) {
            int width = class_3518.method_15282((JsonObject)jsonObject, (String)"width", (int)16);
            int height = class_3518.method_15282((JsonObject)jsonObject, (String)"height", (int)16);
            class_2960 texture = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"texture"));
            return new BookIcon(texture, width, height);
        }
        throw new JsonParseException("BookIcon must have either item or texture defined." + jsonElement);
    }

    private static BookIcon fromString(class_2960 value) {
        if (value.method_12832().endsWith(".png")) {
            return new BookIcon(value, 16, 16);
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(value);
        return new BookIcon(new class_1799((class_1935)item));
    }

    public static BookIcon fromNetwork(class_2540 buffer) {
        if (buffer.readBoolean()) {
            class_2960 texture = buffer.method_10810();
            int width = buffer.method_10816();
            int height = buffer.method_10816();
            return new BookIcon(texture, width, height);
        }
        class_2960 rl = buffer.method_10810();
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(rl);
        return new BookIcon(new class_1799((class_1935)item));
    }

    public void render(class_332 guiGraphics, int x, int y) {
        if (this.texture != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25293(this.texture, x, y, 16, 16, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            guiGraphics.method_51427(this.itemStack, x, y);
        }
    }

    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.texture != null);
        if (this.texture != null) {
            buffer.method_10812(this.texture);
            buffer.method_10804(this.width);
            buffer.method_10804(this.height);
        } else {
            buffer.method_10812(class_7923.field_41178.method_10221((Object)this.itemStack.method_7909()));
        }
    }
}

