/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestAdvancementMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class BookAdvancementCondition
extends BookCondition {
    protected class_2960 advancementId;

    public BookAdvancementCondition(class_2561 component, class_2960 advancementId) {
        super(component);
        this.advancementId = advancementId;
    }

    public static BookAdvancementCondition fromJson(JsonObject json) {
        class_2960 advancementId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"advancement_id"));
        class_5250 tooltip = null;
        if (json.has("tooltip")) {
            tooltip = BookAdvancementCondition.tooltipFromJson(json);
        }
        return new BookAdvancementCondition((class_2561)tooltip, advancementId);
    }

    public static BookAdvancementCondition fromNetwork(class_2540 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? buffer.method_10808() : null;
        class_2960 advancementId = buffer.method_10810();
        return new BookAdvancementCondition(tooltip, advancementId);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.ADVANCEMENT;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.method_10805(this.tooltip);
        }
        buffer.method_10812(this.advancementId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_161 advancement = serverPlayer.method_5682().method_3851().method_12896(this.advancementId);
            return advancement != null && serverPlayer.method_14236().method_12882(advancement).method_740();
        }
        return false;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip != null) {
            return List.of(this.tooltip);
        }
        class_5250 tooltip = class_2561.method_43469((String)"tooltip.modonomicon..condition.advancement", (Object[])new Object[]{DistHelper.getAdvancementTitle(player, this.advancementId)});
        return List.of(tooltip);
    }

    public static class DistHelper {
        public static class_2561 getAdvancementTitle(class_1657 player, class_2960 advancementId) {
            if (player instanceof class_746) {
                class_746 localPlayer = (class_746)player;
                class_161 adv = localPlayer.field_3944.method_2869().method_2863().method_716(advancementId);
                if (adv == null) {
                    adv = BookDataManager.Client.get().getAdvancement(advancementId);
                }
                if (adv == null) {
                    Services.NETWORK.sendToServer(new RequestAdvancementMessage(advancementId));
                    return class_2561.method_43471((String)"tooltip.modonomicon..condition.advancement.loading");
                }
                if (adv.method_686() == null) {
                    return class_2561.method_43471((String)"tooltip.modonomicon..condition.advancement.hidden");
                }
                return adv.method_686().method_811();
            }
            return class_2561.method_43470((String)"Unknown");
        }
    }
}

