/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class BookAndCondition
extends BookCondition {
    protected BookCondition[] children;
    protected List<class_2561> tooltips;

    public BookAndCondition(class_2561 component, BookCondition[] children) {
        super(component);
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("AndCondition must have at least one child.");
        }
        this.children = children;
    }

    public static BookAndCondition fromJson(JsonObject json) {
        ArrayList<BookCondition> children = new ArrayList<BookCondition>();
        for (JsonElement j : class_3518.method_15261((JsonObject)json, (String)"children")) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Condition children must be an array of JsonObjects.");
            }
            children.add(BookCondition.fromJson(j.getAsJsonObject()));
        }
        class_5250 tooltip = BookAndCondition.tooltipFromJson(json);
        return new BookAndCondition((class_2561)tooltip, children.toArray(new BookCondition[children.size()]));
    }

    public static BookAndCondition fromNetwork(class_2540 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? buffer.method_10808() : null;
        int childCount = buffer.method_10816();
        BookCondition[] children = new BookCondition[childCount];
        for (int i = 0; i < childCount; ++i) {
            children[i] = BookCondition.fromNetwork(buffer);
        }
        return new BookAndCondition(tooltip, children);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.AND;
    }

    @Override
    public boolean requiresMultiPassUnlockTest() {
        return Arrays.stream(this.children).anyMatch(BookCondition::requiresMultiPassUnlockTest);
    }

    public BookCondition[] children() {
        return this.children;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.method_10805(this.tooltip);
        }
        buffer.method_10804(this.children.length);
        for (BookCondition child : this.children) {
            BookCondition.toNetwork(child, buffer);
        }
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        for (BookCondition child : this.children) {
            if (child.test(context, player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean testOnLoad() {
        for (BookCondition child : this.children) {
            if (child.testOnLoad()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<class_2561>();
            if (this.tooltip != null) {
                this.tooltips.add(this.tooltip);
            }
            for (BookCondition child : this.children) {
                this.tooltips.addAll(child.getTooltip(player, context));
            }
        }
        return this.tooltips != null ? this.tooltips : List.of();
    }
}

