/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class BookCategoryHasVisibleEntriesCondition
extends BookCondition {
    protected class_2960 categoryId;

    public BookCategoryHasVisibleEntriesCondition(class_2561 tooltip, class_2960 categoryId) {
        super(tooltip);
        this.categoryId = categoryId;
    }

    public static BookCategoryHasVisibleEntriesCondition fromJson(JsonObject json) {
        class_2960 categoryId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"category_id"));
        class_5250 tooltip = class_2561.method_43469((String)"tooltip.modonomicon..condition.has_visible_entries", (Object[])new Object[]{categoryId});
        return new BookCategoryHasVisibleEntriesCondition((class_2561)tooltip, categoryId);
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.method_10805(this.tooltip);
        }
        buffer.method_10812(this.categoryId);
    }

    public static BookCategoryHasVisibleEntriesCondition fromNetwork(class_2540 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? buffer.method_10808() : null;
        class_2960 entryId = buffer.method_10810();
        return new BookCategoryHasVisibleEntriesCondition(tooltip, entryId);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES;
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        BookCategory category = context.book.getCategory(this.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Category with id " + this.categoryId + " not found in book " + context.getBook().getId() + "for BookCategoryHasVisibleEntriesCondition. This happened while trying to unlock " + context);
        }
        if (category.getEntries().isEmpty()) {
            return false;
        }
        for (BookEntry entry : category.getEntries().values()) {
            if (!entry.getEntryDisplayState(player).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = class_2561.method_43469((String)"tooltip.modonomicon..condition.has_visible_entries", (Object[])new Object[]{class_2561.method_43471((String)entryContext.getBook().getEntry(this.categoryId).getName())});
        }
        return super.getTooltip(player, context);
    }
}

