/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.ResolvedBookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryReadCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.EntryDisplayState;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public abstract class BookEntry {
    protected final BookEntryData data;
    protected class_2960 id;
    protected Book book;
    protected BookCategory category;
    protected List<ResolvedBookEntryParent> parents;
    protected class_2960 commandToRunOnFirstReadId;
    protected BookCommand commandToRunOnFirstRead;

    public BookEntry(class_2960 id, BookEntryData data, class_2960 commandToRunOnFirstReadId) {
        this.id = id;
        this.data = data;
        this.commandToRunOnFirstReadId = commandToRunOnFirstReadId;
    }

    public int getX() {
        return this.data.x;
    }

    public int getY() {
        return this.data.y;
    }

    public abstract class_2960 getType();

    public abstract BookContentScreen openEntry(BookCategoryScreen var1);

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
    }

    public void build(class_1937 level, BookCategory category) {
        this.book = category.getBook();
        this.category = category;
        ArrayList<ResolvedBookEntryParent> newParents = new ArrayList<ResolvedBookEntryParent>();
        for (BookEntryParent parent : this.data.parents) {
            BookEntry parentEntry = this.getBook().getEntry(parent.getEntryId());
            if (parentEntry == null) {
                BookErrorManager.get().error("Entry \"" + this.getId() + "\" has a parent that does not exist in this book: \"" + parent.getEntryId() + "\". This parent will be ignored");
                continue;
            }
            newParents.add(new ResolvedBookEntryParent(parent, parentEntry));
        }
        this.parents = newParents;
        if (this.commandToRunOnFirstReadId != null) {
            this.commandToRunOnFirstRead = this.getBook().getCommand(this.commandToRunOnFirstReadId);
            if (this.commandToRunOnFirstRead == null) {
                BookErrorManager.get().error("Command to run on first read \"" + this.commandToRunOnFirstReadId + "\" does not exist in this book. Set to null.");
                this.commandToRunOnFirstReadId = null;
            }
        }
    }

    public EntryDisplayState getEntryDisplayState(class_1657 player) {
        boolean isEntryUnlocked = BookUnlockStateManager.get().isUnlockedFor(player, this);
        if (isEntryUnlocked) {
            return EntryDisplayState.UNLOCKED;
        }
        if (!this.getParents().isEmpty()) {
            boolean anyParentsUnlocked = false;
            boolean allParentsUnlocked = true;
            for (BookEntryParent bookEntryParent : this.getParents()) {
                if (!BookUnlockStateManager.get().isUnlockedFor(player, bookEntryParent.getEntry())) {
                    allParentsUnlocked = false;
                    continue;
                }
                anyParentsUnlocked = true;
            }
            if (this.showWhenAnyParentUnlocked() && !anyParentsUnlocked) {
                return EntryDisplayState.HIDDEN;
            }
            if (!this.showWhenAnyParentUnlocked() && !allParentsUnlocked) {
                return EntryDisplayState.HIDDEN;
            }
        }
        return this.hideWhileLocked() ? EntryDisplayState.HIDDEN : EntryDisplayState.LOCKED;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean matchesQuery(String query) {
        return this.data.name().toLowerCase().contains(query);
    }

    public int getPageNumberForAnchor(String anchor) {
        return -1;
    }

    public List<BookPage> getPages() {
        return List.of();
    }

    public List<BookPage> getUnlockedPagesFor(class_1657 player) {
        return List.of();
    }

    public BookCommand getCommandToRunOnFirstRead() {
        return this.commandToRunOnFirstRead;
    }

    public BookCondition getCondition() {
        return this.data.condition;
    }

    public String getName() {
        return this.data.name;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public Book getBook() {
        return this.book;
    }

    public String getDescription() {
        return this.data.description;
    }

    public List<? extends BookEntryParent> getParents() {
        return this.parents == null ? this.data.parents : this.parents;
    }

    public int getEntryBackgroundUIndex() {
        return this.data.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.data.entryBackgroundVIndex;
    }

    public boolean showWhenAnyParentUnlocked() {
        return this.data.showWhenAnyParentUnlocked;
    }

    public boolean hideWhileLocked() {
        return this.data.hideWhileLocked;
    }

    public BookIcon getIcon() {
        return this.data.icon;
    }

    public class_2960 getCategoryId() {
        return this.data.categoryId;
    }

    public abstract void toNetwork(class_2540 var1);

    public record BookEntryData(class_2960 categoryId, List<BookEntryParent> parents, int x, int y, String name, String description, BookIcon icon, int entryBackgroundUIndex, int entryBackgroundVIndex, BookCondition condition, boolean hideWhileLocked, boolean showWhenAnyParentUnlocked) {
        public static BookEntryData fromJson(JsonObject json, boolean autoAddReadConditions) {
            class_2960 categoryId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"category"));
            int x = class_3518.method_15260((JsonObject)json, (String)"x");
            int y = class_3518.method_15260((JsonObject)json, (String)"y");
            ArrayList<BookEntryParent> parents = new ArrayList<BookEntryParent>();
            if (json.has("parents")) {
                for (Object parent2 : class_3518.method_15261((JsonObject)json, (String)"parents")) {
                    parents.add(BookEntryParent.fromJson(parent2.getAsJsonObject()));
                }
            }
            ArrayList<BookPage> pages = new ArrayList<BookPage>();
            if (json.has("pages")) {
                for (JsonElement pageElem : class_3518.method_15261((JsonObject)json, (String)"pages")) {
                    BookErrorManager.get().setContext("Page Index: {}", pages.size());
                    JsonObject pageJson = class_3518.method_15295((JsonElement)pageElem, (String)"page");
                    class_2960 type = new class_2960(class_3518.method_15265((JsonObject)pageJson, (String)"type"));
                    JsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                    BookPage page = loader.fromJson(pageJson);
                    pages.add(page);
                }
            }
            String name = class_3518.method_15265((JsonObject)json, (String)"name");
            String description = class_3518.method_15253((JsonObject)json, (String)"description", (String)"");
            BookIcon icon = BookIcon.fromJson(json.get("icon"));
            int entryBackgroundUIndex = class_3518.method_15282((JsonObject)json, (String)"background_u_index", (int)0);
            int entryBackgroundVIndex = class_3518.method_15282((JsonObject)json, (String)"background_v_index", (int)0);
            BookCondition condition = new BookNoneCondition();
            if (json.has("condition")) {
                condition = BookCondition.fromJson(json.getAsJsonObject("condition"));
            } else if (autoAddReadConditions) {
                if (parents.size() == 1) {
                    condition = new BookEntryReadCondition(null, ((BookEntryParent)parents.get(0)).getEntryId());
                } else if (parents.size() > 1) {
                    List<BookEntryReadCondition> conditions = parents.stream().map(parent -> new BookEntryReadCondition(null, parent.getEntryId())).toList();
                    condition = new BookAndCondition(null, conditions.toArray(new BookEntryReadCondition[0]));
                }
            }
            boolean hideWhileLocked = class_3518.method_15258((JsonObject)json, (String)"hide_while_locked", (boolean)false);
            boolean showWhenAnyParentUnlocked = class_3518.method_15258((JsonObject)json, (String)"show_when_any_parent_unlocked", (boolean)false);
            return new BookEntryData(categoryId, parents, x, y, name, description, icon, entryBackgroundUIndex, entryBackgroundVIndex, condition, hideWhileLocked, showWhenAnyParentUnlocked);
        }

        public static BookEntryData fromNetwork(class_2540 buffer) {
            class_2960 categoryId = buffer.method_10810();
            String name = buffer.method_19772();
            String description = buffer.method_19772();
            BookIcon icon = BookIcon.fromNetwork(buffer);
            int x = buffer.method_10816();
            int y = buffer.method_10816();
            int entryBackgroundUIndex = buffer.method_10816();
            int entryBackgroundVIndex = buffer.method_10816();
            boolean hideWhileLocked = buffer.readBoolean();
            boolean showWhenAnyParentUnlocked = buffer.readBoolean();
            BookCondition condition = BookCondition.fromNetwork(buffer);
            ArrayList<BookEntryParent> parentEntries = new ArrayList<BookEntryParent>();
            int parentCount = buffer.method_10816();
            for (int i = 0; i < parentCount; ++i) {
                parentEntries.add(BookEntryParent.fromNetwork(buffer));
            }
            return new BookEntryData(categoryId, parentEntries, x, y, name, description, icon, entryBackgroundUIndex, entryBackgroundVIndex, condition, hideWhileLocked, showWhenAnyParentUnlocked);
        }

        public void toNetwork(class_2540 buffer) {
            buffer.method_10812(this.categoryId);
            buffer.method_10814(this.name);
            buffer.method_10814(this.description);
            this.icon.toNetwork(buffer);
            buffer.method_10804(this.x);
            buffer.method_10804(this.y);
            buffer.method_10804(this.entryBackgroundUIndex);
            buffer.method_10804(this.entryBackgroundVIndex);
            buffer.writeBoolean(this.hideWhileLocked);
            buffer.writeBoolean(this.showWhenAnyParentUnlocked);
            buffer.method_10812(this.condition.getType());
            this.condition.toNetwork(buffer);
            buffer.method_10804(this.parents.size());
            for (BookEntryParent parent : this.parents) {
                parent.toNetwork(buffer);
            }
        }
    }
}

