/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CategoryLinkBookEntry
extends BookEntry {
    protected class_2960 categoryToOpenId;
    protected BookCategory categoryToOpen;

    public CategoryLinkBookEntry(class_2960 id, BookEntry.BookEntryData data, class_2960 commandToRunOnFirstReadId, class_2960 categoryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.categoryToOpenId = categoryToOpenId;
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.EntryType.CATEGORY_LINK;
    }

    public static CategoryLinkBookEntry fromJson(class_2960 id, JsonObject json, boolean autoAddReadConditions) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(json, autoAddReadConditions);
        class_2960 commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        class_2960 categoryToOpenId = null;
        if (json.has("category_to_open")) {
            categoryToOpenId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"category_to_open"));
        }
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpenId);
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(this.id);
        this.data.toNetwork(buffer);
        buffer.method_43826((Object)this.commandToRunOnFirstReadId, class_2540::method_10812);
        buffer.method_10812(this.categoryToOpenId);
    }

    public static CategoryLinkBookEntry fromNetwork(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        class_2960 commandToRunOnFirstReadId = (class_2960)buffer.method_43827(class_2540::method_10810);
        class_2960 categoryToOpen = buffer.method_10810();
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpen);
    }

    @Override
    public void build(class_1937 level, BookCategory category) {
        super.build(level, category);
        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.getBook().getCategory(this.categoryToOpenId);
            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + this.categoryToOpenId + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    @Override
    public BookContentScreen openEntry(BookCategoryScreen categoryScreen) {
        categoryScreen.getBookOverviewScreen().changeCategory(this.getCategoryToOpen());
        return null;
    }
}

