/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.klikli_dev.modonomicon.util.EntityUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BookEntityPage
extends BookPage {
    protected BookTextHolder entityName;
    protected BookTextHolder text;
    protected String entityId;
    protected float scale = 1.0f;
    protected float offset = 0.0f;
    protected boolean rotate = true;
    protected float defaultRotation = -45.0f;

    public BookEntityPage(BookTextHolder entityName, BookTextHolder text, String entityId, float scale, float offset, boolean rotate, float defaultRotation, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.entityName = entityName;
        this.text = text;
        this.entityId = entityId;
        this.scale = scale;
        this.offset = offset;
        this.rotate = rotate;
        this.defaultRotation = defaultRotation;
    }

    public static BookEntityPage fromJson(JsonObject json) {
        BookTextHolder entityName = BookGsonHelper.getAsBookTextHolder(json, "name", BookTextHolder.EMPTY);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        String entityId = class_3518.method_15265((JsonObject)json, (String)"entity_id");
        float scale = class_3518.method_15277((JsonObject)json, (String)"scale", (float)1.0f);
        float offset = class_3518.method_15277((JsonObject)json, (String)"offset", (float)0.0f);
        boolean rotate = class_3518.method_15258((JsonObject)json, (String)"rotate", (boolean)true);
        float defaultRotation = class_3518.method_15277((JsonObject)json, (String)"default_rotation", (float)-45.0f);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition")) : new BookNoneCondition();
        return new BookEntityPage(entityName, text, entityId, scale, offset, rotate, defaultRotation, anchor, condition);
    }

    public static BookEntityPage fromNetwork(class_2540 buffer) {
        BookTextHolder entityName = BookTextHolder.fromNetwork(buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String entityId = buffer.method_19772();
        float scale = buffer.readFloat();
        float offset = buffer.readFloat();
        boolean rotate = buffer.readBoolean();
        float defaultRotation = buffer.readFloat();
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookEntityPage(entityName, text, entityId, scale, offset, rotate, defaultRotation, anchor, condition);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public float getScale() {
        return this.scale;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean doesRotate() {
        return this.rotate;
    }

    public float getDefaultRotation() {
        return this.defaultRotation;
    }

    public BookTextHolder getEntityName() {
        return this.entityName;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Page.ENTITY;
    }

    @Override
    public void build(class_1937 level, ContentBookEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (this.entityName.isEmpty()) {
            this.entityName = new BookTextHolder((class_2561)class_2561.method_43471((String)EntityUtil.getEntityName(this.entityId)).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.entityName.hasComponent()) {
            this.entityName = new BookTextHolder((class_2561)class_2561.method_43471((String)this.entityName.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        this.entityName.toNetwork(buffer);
        this.text.toNetwork(buffer);
        buffer.method_10814(this.entityId);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(this.offset);
        buffer.writeBoolean(this.rotate);
        buffer.writeFloat(this.defaultRotation);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.entityName.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

