/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import java.util.Arrays;
import net.minecraft.class_1074;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class BookSpotlightPage
extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected class_1856 item;

    public BookSpotlightPage(BookTextHolder title, BookTextHolder text, class_1856 item, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.item = item;
    }

    public static BookSpotlightPage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY);
        class_1856 item = class_1856.method_52177((JsonElement)json.get("item"));
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition")) : new BookNoneCondition();
        return new BookSpotlightPage(title, text, item, anchor, condition);
    }

    public static BookSpotlightPage fromNetwork(class_2540 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        class_1856 item = class_1856.method_8086((class_2540)buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookSpotlightPage(title, text, item, anchor, condition);
    }

    public class_1856 getItem() {
        return this.item;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Page.SPOTLIGHT;
    }

    @Override
    public void build(class_1937 level, ContentBookEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (this.title.isEmpty()) {
            this.title = new BookTextHolder((class_2561)((class_5250)this.item.method_8105()[0].method_7964()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((class_2561)class_2561.method_43471((String)this.title.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        this.title.toNetwork(buffer);
        this.item.method_8088(buffer);
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || Arrays.stream(this.item.method_8105()).anyMatch(i -> class_1074.method_4662((String)i.method_7922(), (Object[])new Object[0]).toLowerCase().contains(query)) || this.text.getString().toLowerCase().contains(query);
    }
}

