/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BookTextPage
extends BookPage {
    protected BookTextHolder title;
    protected boolean useMarkdownInTitle;
    protected boolean showTitleSeparator;
    protected BookTextHolder text;

    public BookTextPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.useMarkdownInTitle = useMarkdownInTitle;
        this.showTitleSeparator = showTitleSeparator;
    }

    public static BookTextPage fromJson(JsonObject json) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY);
        boolean useMarkdownInTitle = class_3518.method_15258((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = class_3518.method_15258((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookCondition condition = json.has("condition") ? BookCondition.fromJson(json.getAsJsonObject("condition")) : new BookNoneCondition();
        return new BookTextPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
    }

    public static BookTextPage fromNetwork(class_2540 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookTextPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
    }

    public boolean useMarkdownInTitle() {
        return this.useMarkdownInTitle;
    }

    public boolean showTitleSeparator() {
        return this.showTitleSeparator;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Page.TEXT;
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = this.useMarkdownInTitle ? new RenderedBookTextHolder(this.title, textRenderer.render(this.title.getString())) : new BookTextHolder((class_2561)class_2561.method_43471((String)this.title.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        this.title.toNetwork(buffer);
        buffer.writeBoolean(this.useMarkdownInTitle);
        buffer.writeBoolean(this.showTitleSeparator);
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

