/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2960;

public class BookVisualStates {
    public static final Codec<BookVisualStates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.concurrentMap(class_2960.field_25139, BookVisualState.CODEC).fieldOf("bookStates").forGetter(s -> s.bookStates)).apply((Applicative)instance, BookVisualStates::new));
    public ConcurrentMap<class_2960, BookVisualState> bookStates;

    public BookVisualStates() {
        this(new ConcurrentHashMap<class_2960, BookVisualState>());
    }

    public BookVisualStates(ConcurrentMap<class_2960, BookVisualState> bookStates) {
        this.bookStates = bookStates;
    }

    public BookVisualState getBookState(Book book) {
        return this.bookStates.computeIfAbsent(book.getId(), id -> new BookVisualState());
    }

    public CategoryVisualState getCategoryState(BookCategory category) {
        return this.getBookState((Book)category.getBook()).categoryStates.computeIfAbsent(category.getId(), id -> new CategoryVisualState());
    }

    public EntryVisualState getEntryState(BookEntry entry) {
        return this.getCategoryState((BookCategory)entry.getCategory()).entryStates.computeIfAbsent(entry.getId(), id -> new EntryVisualState());
    }

    public void setBookState(Book book, BookVisualState state) {
        this.bookStates.put(book.getId(), state);
    }

    public void setEntryState(BookEntry entry, EntryVisualState state) {
        this.getCategoryState((BookCategory)entry.getCategory()).entryStates.put(entry.getId(), state);
    }

    public void setCategoryState(BookCategory category, CategoryVisualState state) {
        this.getBookState((Book)category.getBook()).categoryStates.put(category.getId(), state);
    }
}

