/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.fluid;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.fluid.FabricFluidHolder;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class FluidRenderHelper {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawFluid(class_332 guiGraphics, int width, int height, FabricFluidHolder fluidHolder, int capacity) {
        FluidVariant fluidVariant = fluidHolder.toVariant();
        class_3611 fluid = fluidHolder.getFluid();
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidRenderHelper.getStillFluidSprite(fluidVariant).ifPresent(fluidStillSprite -> {
            int fluidColor = FluidRenderHelper.getColorTint(fluidVariant);
            long amount = fluidHolder.getAmount();
            long scaledAmount = amount * (long)height / (long)capacity;
            if (amount > 0L && scaledAmount < 1L) {
                scaledAmount = 1L;
            }
            if (scaledAmount > (long)height) {
                scaledAmount = height;
            }
            FluidRenderHelper.drawTiledSprite(guiGraphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
        });
    }

    private static int getColorTint(FluidVariant fluidVariant) {
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return fluidColor | 0xFF000000;
    }

    private static Optional<class_1058> getStillFluidSprite(FluidVariant fluidVariant) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return Optional.ofNullable(sprite);
    }

    private static void drawTiledSprite(class_332 guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        FluidRenderHelper.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    FluidRenderHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }

    public static List<class_2561> getTooltip(FabricFluidHolder fluidHolder, int capacity, class_1836 tooltipFlag, FluidHelper.TooltipMode tooltipMode) {
        FluidVariant variant = fluidHolder.toVariant();
        class_3611 fluidType = fluidHolder.getFluid();
        try {
            if (fluidType.method_15780(class_3612.field_15906)) {
                return new ArrayList<class_2561>();
            }
            List tooltip = FluidVariantRendering.getTooltip((FluidVariant)variant);
            long amount = fluidHolder.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                class_5250 amountString = class_2561.method_43469((String)"tooltip.modonomicon.fluid.amount_and_capacity", (Object[])new Object[]{milliBuckets, capacity});
                tooltip.add(amountString.method_27692(class_124.field_1080));
            } else if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT) {
                class_5250 amountString = class_2561.method_43469((String)"tooltip.modonomicon.fluid.amount", (Object[])new Object[]{milliBuckets});
                tooltip.add(amountString.method_27692(class_124.field_1080));
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            class_2561 displayName = FluidVariantAttributes.getName((FluidVariant)variant);
            Modonomicon.LOG.error("Failed to get tooltip for fluid: " + displayName, (Throwable)e);
            return new ArrayList<class_2561>();
        }
    }
}

