/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.api.events.EntryClickedEvent;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.CategoryLinkBookEntry;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.EntryConnectionRenderer;
import com.klikli_dev.modonomicon.client.gui.book.EntryDisplayState;
import com.klikli_dev.modonomicon.events.ModonomiconEvents;
import com.klikli_dev.modonomicon.networking.BookEntryReadMessage;
import com.klikli_dev.modonomicon.networking.SaveCategoryStateMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class BookCategoryScreen {
    public static final int ENTRY_GRID_SCALE = 30;
    public static final int ENTRY_GAP = 2;
    public static final int MAX_SCROLL = 512;
    public static final int ENTRY_HEIGHT = 26;
    public static final int ENTRY_WIDTH = 26;
    private final BookOverviewScreen bookOverviewScreen;
    private final BookCategory category;
    private final EntryConnectionRenderer connectionRenderer;
    private float scrollX = 0.0f;
    private float scrollY = 0.0f;
    private boolean isScrolling;
    private float targetZoom;
    private float currentZoom;
    private class_2960 openEntry;

    public BookCategoryScreen(BookOverviewScreen bookOverviewScreen, BookCategory category) {
        this.bookOverviewScreen = bookOverviewScreen;
        this.category = category;
        this.connectionRenderer = new EntryConnectionRenderer(category.getEntryTextures());
        this.currentZoom = this.targetZoom = 0.7f;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public float getXOffset() {
        return (float)this.bookOverviewScreen.getInnerWidth() / 2.0f * (1.0f / this.currentZoom) - this.scrollX / 2.0f;
    }

    public float getYOffset() {
        return (float)this.bookOverviewScreen.getInnerHeight() / 2.0f * (1.0f / this.currentZoom) - this.scrollY / 2.0f;
    }

    public void render(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (ClientServices.CLIENT_CONFIG.enableSmoothZoom()) {
            float diff = this.targetZoom - this.currentZoom;
            this.currentZoom += Math.min(pPartialTick * 0.6666667f, 1.0f) * diff;
        } else {
            this.currentZoom = this.targetZoom;
        }
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth();
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        guiGraphics.method_44379(innerX, innerY, innerX + innerWidth - 1, innerY + innerHeight - 1);
        this.renderEntries(guiGraphics, pMouseX, pMouseY);
        guiGraphics.method_44380();
    }

    public void zoom(double delta) {
        float step = 1.2f;
        if (delta < 0.0 && (double)this.targetZoom > 0.5 || delta > 0.0 && this.targetZoom < 1.0f) {
            this.targetZoom *= delta > 0.0 ? step : 1.0f / step;
        }
        if (this.targetZoom > 1.0f) {
            this.targetZoom = 1.0f;
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else {
            this.scroll(pDragX * 1.5, pDragY * 1.5);
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayStyle = entry.getEntryDisplayState((class_1657)this.bookOverviewScreen.getMinecraft().field_1724);
            if (!this.isEntryHovered(entry, xOffset, yOffset, (int)pMouseX, (int)pMouseY)) continue;
            EntryClickedEvent event = new EntryClickedEvent(this.category.getBook().getId(), entry.getId(), pMouseX, pMouseY, pButton, displayStyle);
            if (ModonomiconEvents.client().entryClicked(event)) {
                return true;
            }
            if (!displayStyle.isUnlocked()) continue;
            this.openEntry(entry);
            return true;
        }
        return false;
    }

    @Nullable
    public BookContentScreen openEntry(BookEntry entry) {
        if (!BookUnlockStateManager.get().isReadFor((class_1657)class_310.method_1551().field_1724, entry)) {
            Services.NETWORK.sendToServer(new BookEntryReadMessage(entry.getBook().getId(), entry.getId()));
        }
        if (!(entry instanceof CategoryLinkBookEntry)) {
            this.openEntry = entry.getId();
        }
        return entry.openEntry(this);
    }

    @Nullable
    public BookContentScreen openContentEntry(ContentBookEntry entry) {
        if (BookGuiManager.get().isEntryAlreadyDisplayed(entry)) {
            return (BookContentScreen)class_310.method_1551().field_1755;
        }
        BookContentScreen bookContentScreen = new BookContentScreen(this.bookOverviewScreen.getCurrentCategoryScreen().bookOverviewScreen, entry);
        ClientServices.GUI.pushGuiLayer(bookContentScreen);
        this.openEntry = entry.getId();
        return bookContentScreen;
    }

    public void renderBackground(class_332 guiGraphics) {
        float yScale;
        float scale;
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth();
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        int backgroundWidth = this.category.getBackgroundWidth();
        int backgroundHeight = this.category.getBackgroundHeight();
        int MAX_SCROLL = Math.max(backgroundWidth, backgroundHeight);
        float backgroundTextureZoomMultiplier = this.category.getBackgroundTextureZoomMultiplier();
        float xScale = (float)MAX_SCROLL * 2.0f / ((float)MAX_SCROLL + (float)this.bookOverviewScreen.getFrameThicknessW() - (float)this.bookOverviewScreen.getFrameWidth());
        float xOffset = xScale == (scale = Math.max(xScale, yScale = (float)MAX_SCROLL * 2.0f / ((float)MAX_SCROLL + (float)this.bookOverviewScreen.getFrameThicknessH() - (float)this.bookOverviewScreen.getFrameHeight()))) ? 0.0f : ((float)MAX_SCROLL - ((float)innerWidth + (float)MAX_SCROLL * 2.0f / scale)) / 2.0f;
        float yOffset = yScale == scale ? 0.0f : ((float)MAX_SCROLL - ((float)innerHeight + (float)MAX_SCROLL * 2.0f / scale)) / 2.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        if (!this.category.getBackgroundParallaxLayers().isEmpty()) {
            this.category.getBackgroundParallaxLayers().forEach(layer -> this.renderBackgroundParallaxLayer(guiGraphics, (BookCategoryBackgroundParallaxLayer)layer, innerX, innerY, innerWidth, innerHeight, this.scrollX, this.scrollY, scale, xOffset, yOffset, this.currentZoom, backgroundWidth, backgroundHeight, backgroundTextureZoomMultiplier));
        } else {
            guiGraphics.method_25290(this.category.getBackground(), innerX, innerY, (this.scrollX + (float)MAX_SCROLL) / scale + xOffset, (this.scrollY + (float)MAX_SCROLL) / scale + yOffset, innerWidth, innerHeight, (int)((float)backgroundHeight * backgroundTextureZoomMultiplier), (int)((float)backgroundWidth * backgroundTextureZoomMultiplier));
        }
    }

    public void renderBackgroundParallaxLayer(class_332 guiGraphics, BookCategoryBackgroundParallaxLayer layer, int x, int y, int width, int height, float scrollX, float scrollY, float parallax, float xOffset, float yOffset, float zoom, int backgroundWidth, int backgroundHeight, float backgroundTextureZoomMultiplier) {
        float parallax1 = parallax / layer.getSpeed();
        RenderSystem.setShaderTexture((int)0, (class_2960)layer.getBackground());
        if (layer.getVanishZoom() == -1.0f || layer.getVanishZoom() > zoom) {
            guiGraphics.method_25290(layer.getBackground(), x, y, (scrollX + 512.0f) / parallax1 + xOffset, (scrollY + 512.0f) / parallax1 + yOffset, width, height, (int)((float)backgroundHeight * backgroundTextureZoomMultiplier), (int)((float)backgroundWidth * backgroundTextureZoomMultiplier));
        }
    }

    private void renderEntries(class_332 guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(this.currentZoom, this.currentZoom, 1.0f);
        class_746 player = this.bookOverviewScreen.getMinecraft().field_1724;
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = entry.getEntryDisplayState((class_1657)player);
            boolean isHovered = this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY);
            if (!displayState.isVisible()) continue;
            int texX = entry.getEntryBackgroundVIndex() * 26;
            int texY = entry.getEntryBackgroundUIndex() * 26;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(xOffset, yOffset, 0.0f);
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 10.0f);
            if (!displayState.isUnlocked()) {
                RenderSystem.setShaderColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            } else if (isHovered) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            }
            guiGraphics.method_25302(this.category.getEntryTextures(), entry.getX() * 30 + 2, entry.getY() * 30 + 2, texX, texY, 26, 26);
            guiGraphics.method_51448().method_22903();
            entry.getIcon().render(guiGraphics, entry.getX() * 30 + 2 + 5, entry.getY() * 30 + 2 + 5);
            guiGraphics.method_51448().method_22909();
            if (displayState.isUnlocked() && !BookUnlockStateManager.get().isReadFor((class_1657)this.bookOverviewScreen.getMinecraft().field_1724, entry)) {
                int U = 350;
                int V = 19;
                int width = 11;
                int height = 11;
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 11.0f);
                BookContentScreen.drawFromTexture(guiGraphics, this.bookOverviewScreen.getBook(), entry.getX() * 30 + 2 + 16 + 2, entry.getY() * 30 + 2 - 2, 350 + (isHovered ? 11 : 0), 19, 11, 11);
                guiGraphics.method_51448().method_22909();
            }
            guiGraphics.method_51448().method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderConnections(guiGraphics, entry, xOffset, yOffset);
        }
        guiGraphics.method_51448().method_22909();
    }

    public void renderEntryTooltips(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = entry.getEntryDisplayState((class_1657)this.bookOverviewScreen.getMinecraft().field_1724);
            if (!displayState.isVisible()) continue;
            this.renderTooltip(guiGraphics, entry, displayState, xOffset, yOffset, mouseX, mouseY);
        }
    }

    private boolean isEntryHovered(BookEntry entry, float xOffset, float yOffset, int mouseX, int mouseY) {
        int x = (int)(((float)(entry.getX() * 30) + xOffset + 2.0f) * this.currentZoom);
        int y = (int)(((float)(entry.getY() * 30) + yOffset + 2.0f) * this.currentZoom);
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth();
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        return mouseX >= x && (float)mouseX <= (float)x + 26.0f * this.currentZoom && mouseY >= y && (float)mouseY <= (float)y + 26.0f * this.currentZoom && mouseX >= innerX && mouseX <= innerX + innerWidth && mouseY >= innerY && mouseY <= innerY + innerHeight;
    }

    private void renderTooltip(class_332 guiGraphics, BookEntry entry, EntryDisplayState displayState, float xOffset, float yOffset, int mouseX, int mouseY) {
        if (this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY)) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (displayState == EntryDisplayState.LOCKED) {
                tooltip.addAll(entry.getCondition().getTooltip((class_1657)this.bookOverviewScreen.getMinecraft().field_1724, BookConditionEntryContext.of(this.bookOverviewScreen.getBook(), entry)));
            } else if (displayState == EntryDisplayState.UNLOCKED) {
                tooltip.add(class_2561.method_43471((String)entry.getName()).method_27692(class_124.field_1067));
                if (!entry.getDescription().isEmpty()) {
                    tooltip.add(class_2561.method_43471((String)entry.getDescription()));
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_51437(class_310.method_1551().field_1772, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderConnections(class_332 guiGraphics, BookEntry entry, float xOffset, float yOffset) {
        RenderSystem.enableBlend();
        for (BookEntryParent bookEntryParent : entry.getParents()) {
            EntryDisplayState parentDisplayState = bookEntryParent.getEntry().getEntryDisplayState((class_1657)this.bookOverviewScreen.getMinecraft().field_1724);
            if (parentDisplayState == EntryDisplayState.HIDDEN) continue;
            int blitOffset = 0;
            this.connectionRenderer.setBlitOffset(blitOffset);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(xOffset, yOffset, 0.0f);
            this.connectionRenderer.render(guiGraphics, entry, bookEntryParent);
            guiGraphics.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
    }

    private void scroll(double pDragX, double pDragY) {
        this.scrollX = (float)class_3532.method_15350((double)((double)this.scrollX - pDragX), (double)-512.0, (double)512.0);
        this.scrollY = (float)class_3532.method_15350((double)((double)this.scrollY - pDragY), (double)-512.0, (double)512.0);
    }

    private void loadCategoryState() {
        CategoryVisualState state = BookVisualStateManager.get().getCategoryStateFor((class_1657)this.bookOverviewScreen.getMinecraft().field_1724, this.category);
        BookGuiManager.get().currentCategory = this.category;
        BookGuiManager.get().currentCategoryScreen = this;
        if (state != null) {
            BookEntry openEntry;
            this.scrollX = state.scrollX;
            this.scrollY = state.scrollY;
            this.targetZoom = state.targetZoom;
            this.currentZoom = state.targetZoom;
            if (state.openEntry != null && (openEntry = this.category.getEntry(state.openEntry)) != null && !(openEntry instanceof CategoryLinkBookEntry)) {
                this.openEntry(openEntry);
            }
        }
    }

    public void onDisplay() {
        this.loadCategoryState();
    }

    public void onClose() {
        Services.NETWORK.sendToServer(new SaveCategoryStateMessage(this.category, this.scrollX, this.scrollY, this.currentZoom, this.openEntry));
    }

    public void onCloseEntry(BookContentScreen screen) {
        this.openEntry = null;
    }

    public BookOverviewScreen getBookOverviewScreen() {
        return this.bookOverviewScreen;
    }

    public void setOpenEntry(class_2960 openEntry) {
        this.openEntry = openEntry;
    }
}

