/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.integration.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookContentScreen
extends BookPaginatedScreen {
    public static final int TOP_PADDING = 15;
    public static final int LEFT_PAGE_X = 12;
    public static final int RIGHT_PAGE_X = 141;
    public static final int PAGE_WIDTH = 124;
    public static final int PAGE_HEIGHT = 128;
    public static final int MAX_TITLE_WIDTH = 120;
    public static final int CLICK_SAFETY_MARGIN = 20;
    private static long lastTurnPageSoundTime;
    private final ContentBookEntry entry;
    private final class_2960 bookContentTexture;
    public int ticksInBook;
    public boolean simulateEscClosing;
    private List<BookPage> unlockedPages;
    private BookPage leftPage;
    private BookPage rightPage;
    private BookPageRenderer<?> leftPageRenderer;
    private BookPageRenderer<?> rightPageRenderer;
    private int openPagesIndex;
    private List<class_2561> tooltip;
    private class_1799 tooltipStack;
    private FluidHolder tooltipFluidStack;
    private boolean isHoveringItemLink;

    public BookContentScreen(BookOverviewScreen parentScreen, ContentBookEntry entry) {
        super((class_2561)class_2561.method_43470((String)""), parentScreen);
        this.field_22787 = class_310.method_1551();
        this.entry = entry;
        this.bookContentTexture = this.parentScreen.getBook().getBookContentTexture();
        this.loadEntryState();
    }

    public static void drawFromTexture(class_332 guiGraphics, Book book, int x, int y, int u, int v, int w, int h) {
        guiGraphics.method_25290(book.getBookContentTexture(), x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public static void drawTitleSeparator(class_332 guiGraphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        BookContentScreen.drawFromTexture(guiGraphics, book, rx, y, 0, 253, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(class_332 guiGraphics, Book book, int x, int y) {
        BookContentScreen.drawFromTexture(guiGraphics, book, x, y, 496, 0, 16, 16);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6L) {
            class_3414 sound = (class_3414)class_7923.field_41172.method_10223(book.getTurnPageSound());
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)sound, (float)((float)(0.7 + Math.random() * 0.3))));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public static void renderBookBackground(class_332 guiGraphics, class_2960 bookContentTexture) {
        int x = 0;
        int y = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(bookContentTexture, x, y, 0.0f, 0.0f, 272, 178, 512, 256);
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public ContentBookEntry getEntry() {
        return this.entry;
    }

    @Override
    public Book getBook() {
        return this.entry.getBook();
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 2 < this.unlockedPages.size();
    }

    public void setTooltip(class_2561 ... strings) {
        this.setTooltip(List.of(strings));
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.resetTooltip();
        this.tooltip = tooltip;
    }

    public void setTooltipStack(class_1799 stack) {
        this.resetTooltip();
        this.tooltipStack = stack;
    }

    public void setTooltipStack(FluidHolder stack) {
        this.resetTooltip();
        this.tooltipFluidStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void renderItemStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1799 stack) {
        if (stack.method_7960() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.method_51427(stack, x, y);
        guiGraphics.method_51431(this.field_22793, stack, x, y);
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    public void renderItemStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<class_1799> stacks, int countOverride) {
        List<class_1799> filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            class_1799 currentStack = filteredStacks.get(this.ticksInBook / 20 % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.method_46651(countOverride) : currentStack);
        }
    }

    public void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), -1);
    }

    public void renderIngredient(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, class_1856 ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.method_8105()), countOverride);
    }

    public void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, 1000);
    }

    public void renderFluidStack(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity);
        guiGraphics.method_51448().method_22909();
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    public void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, 1000);
    }

    public void renderFluidStacks(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        List<FluidHolder> filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get(this.ticksInBook / 20 % filteredStacks.size()), capacity);
        }
    }

    private int getOpenPagesIndexForPage(int pageIndex) {
        for (int i = 0; i < this.unlockedPages.size(); ++i) {
            int pageNumber = this.unlockedPages.get(i).getPageNumber();
            if (pageNumber == pageIndex) {
                return i & 0xFFFFFFFE;
            }
            if (pageNumber > pageIndex) break;
        }
        return 0;
    }

    public void goToPage(int pageIndex, boolean playSound) {
        int openPagesIndex = this.getOpenPagesIndexForPage(pageIndex);
        if (openPagesIndex >= 0 && openPagesIndex < this.unlockedPages.size()) {
            if (this.openPagesIndex != openPagesIndex) {
                this.openPagesIndex = openPagesIndex;
                this.onPageChanged();
                if (playSound) {
                    BookContentScreen.playTurnPageSound(this.getBook());
                }
            }
        } else {
            Modonomicon.LOG.warn("Tried to change to page index {} corresponding with openPagesIndex {} but max open pages index is {}.", new Object[]{pageIndex, openPagesIndex, this.unlockedPages.size()});
        }
    }

    public class_2583 getClickedComponentStyleAtForPage(BookPageRenderer<?> page, double pMouseX, double pMouseY) {
        if (page != null) {
            return page.getClickedComponentStyleAt(pMouseX - (double)this.bookLeft - (double)page.left, pMouseY - (double)this.bookTop - (double)page.top);
        }
        return null;
    }

    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        class_2583 leftPageClickedStyle = this.getClickedComponentStyleAtForPage(this.leftPageRenderer, pMouseX, pMouseY);
        if (leftPageClickedStyle != null) {
            return leftPageClickedStyle;
        }
        return this.getClickedComponentStyleAtForPage(this.rightPageRenderer, pMouseX, pMouseY);
    }

    public int getBookLeft() {
        return this.bookLeft;
    }

    public int getBookTop() {
        return this.bookTop;
    }

    public void removeRenderableWidgets(@NotNull Collection<? extends class_4068> renderables) {
        this.field_33816.removeIf(renderables::contains);
        this.method_25396().removeIf(c -> c instanceof class_4068 && renderables.contains(c));
        this.field_33815.removeIf(n -> n instanceof class_4068 && renderables.contains(n));
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? (this.openPagesIndex -= 2) : (this.openPagesIndex += 2);
            this.onPageChanged();
            if (playSound) {
                BookContentScreen.playTurnPageSound(this.getBook());
            }
        }
    }

    protected void drawTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltipStack != null) {
            List<class_2561> tooltip = this.getTooltipFromItem(this.tooltipStack);
            guiGraphics.method_51434(class_310.method_1551().field_1772, tooltip, pMouseX, pMouseY);
        } else if (this.tooltipFluidStack != null) {
            List<class_2561> tooltip = this.getTooltipFromFluid(this.tooltipFluidStack);
            guiGraphics.method_51434(class_310.method_1551().field_1772, tooltip, pMouseX, pMouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.method_51434(class_310.method_1551().field_1772, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected boolean clickPage(BookPageRenderer<?> page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)this.bookLeft - (double)page.left, mouseY - (double)this.bookTop - (double)page.top, mouseButton);
        }
        return false;
    }

    protected void renderPage(class_332 guiGraphics, BookPageRenderer<?> page, int pMouseX, int pMouseY, float pPartialTick) {
        if (page == null) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)page.left, (float)page.top, 0.0f);
        page.render(guiGraphics, pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top, pPartialTick);
        guiGraphics.method_51448().method_22909();
    }

    protected void beginDisplayPages() {
        if (this.leftPageRenderer != null) {
            this.leftPageRenderer.onEndDisplayPage(this);
        }
        if (this.rightPageRenderer != null) {
            this.rightPageRenderer.onEndDisplayPage(this);
        }
        int leftPageIndex = this.openPagesIndex;
        int rightPageIndex = leftPageIndex + 1;
        this.leftPage = leftPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(leftPageIndex) : null;
        BookPage bookPage = this.rightPage = rightPageIndex < this.unlockedPages.size() ? this.unlockedPages.get(rightPageIndex) : null;
        if (this.leftPage != null) {
            this.leftPageRenderer = PageRendererRegistry.getPageRenderer(this.leftPage.getType()).create(this.leftPage);
            this.leftPageRenderer.onBeginDisplayPage(this, 12, 15);
        } else {
            this.leftPageRenderer = null;
        }
        if (this.rightPage != null) {
            this.rightPageRenderer = PageRendererRegistry.getPageRenderer(this.rightPage.getType()).create(this.rightPage);
            this.rightPageRenderer.onBeginDisplayPage(this, 141, 15);
        } else {
            this.rightPageRenderer = null;
        }
    }

    protected void onPageChanged() {
        this.beginDisplayPages();
    }

    protected void resetTooltip() {
        this.tooltip = null;
        this.tooltipStack = null;
        this.tooltipFluidStack = null;
    }

    private void loadEntryState() {
        EntryVisualState state = BookVisualStateManager.get().getEntryStateFor((class_1657)this.parentScreen.getMinecraft().field_1724, this.entry);
        BookGuiManager.get().currentEntry = this.entry;
        BookGuiManager.get().currentContentScreen = this;
        if (state != null) {
            this.openPagesIndex = state.openPagesIndex;
        }
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        this.resetTooltip();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -1300.0f);
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookContentScreen.renderBookBackground(guiGraphics, this.bookContentTexture);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderPage(guiGraphics, this.leftPageRenderer, pMouseX, pMouseY, pPartialTick);
        this.renderPage(guiGraphics, this.rightPageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_51448().method_22909();
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void method_25419() {
        if (this.simulateEscClosing || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)256)) {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry, this.openPagesIndex));
            super.method_25419();
            this.parentScreen.method_25419();
            this.simulateEscClosing = false;
        } else {
            Services.NETWORK.sendToServer(new SaveEntryStateMessage(this.entry, ClientServices.CLIENT_CONFIG.storeLastOpenPageWhenClosingEntry() ? this.openPagesIndex : 0));
            this.parentScreen.getCurrentCategoryScreen().onCloseEntry(this);
            ClientServices.GUI.popGuiLayer();
        }
    }

    public <T extends class_364 & class_4068> T method_37063(T pWidget) {
        return (T)super.method_37063(pWidget);
    }

    public void renderComponentHoverEffect(class_332 guiGraphics, @Nullable class_2583 style, int mouseX, int mouseY) {
        class_2558 clickEvent;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        class_2583 newStyle = style;
        if (style != null && style.method_10969() != null && style.method_10969().method_10892() == class_2568.class_5247.field_24342 && (clickEvent = style.method_10970()) != null) {
            Book book;
            Object link;
            if (clickEvent.method_10845() == class_2558.class_2559.field_11748 && BookLink.isBookLink(clickEvent.method_10844())) {
                link = BookLink.from(this.getBook(), clickEvent.method_10844());
                book = BookDataManager.get().getBook(((BookLink)link).bookId);
                if (((BookLink)link).entryId != null) {
                    BookEntry entry = book.getEntry(((BookLink)link).entryId);
                    Integer page = ((BookLink)link).pageNumber;
                    if (((BookLink)link).pageAnchor != null) {
                        page = entry.getPageNumberForAnchor(((BookLink)link).pageAnchor);
                    }
                    if (!BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, entry)) {
                        oldComponent = (class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342);
                        class_5250 newComponent = class_2561.method_43469((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, class_2561.method_43471((String)"modonomicon.gui.hover.book_entry_link_locked_info").method_27694(s -> s.method_36139(16711701).method_10982(Boolean.valueOf(true))).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"modonomicon.gui.hover.book_entry_link_locked_info.hint", (Object[])new Object[]{class_2561.method_43471((String)entry.getCategory().getName()).method_27694(s -> s.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)))}).method_27694(s -> s.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1068)))});
                        newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)newComponent));
                    } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, entry.getPages().get(page))) {
                        oldComponent = (class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342);
                        class_5250 newComponent = class_2561.method_43469((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, class_2561.method_43471((String)"modonomicon.gui.hover.book_page_link_locked_info").method_27694(s -> s.method_36139(16711701).method_10982(Boolean.valueOf(true))).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"modonomicon.gui.hover.book_page_link_locked_info.hint", (Object[])new Object[]{class_2561.method_43471((String)entry.getName()).method_27694(s -> s.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))), class_2561.method_43471((String)entry.getCategory().getName()).method_27694(s -> s.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)))}).method_27694(s -> s.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1068)))});
                        newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)newComponent));
                    }
                }
            }
            if (clickEvent.method_10845() == class_2558.class_2559.field_11750 && CommandLink.isCommandLink(clickEvent.method_10844())) {
                link = CommandLink.from(this.getBook(), clickEvent.method_10844());
                book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    class_2561 oldComponent = (class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342);
                    if (!BookUnlockStateManager.get().canRunFor((class_1657)this.field_22787.field_1724, command)) {
                        class_5250 hoverComponent = class_2561.method_43471((String)"modonomicon.gui.hover.command_link.unavailable").method_27692(class_124.field_1061);
                        newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverComponent));
                        oldComponent = hoverComponent;
                    }
                    if (BookContentScreen.method_25442()) {
                        class_5250 newComponent = oldComponent.method_27661().method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)command.getCommand()).method_27692(class_124.field_1080));
                        newStyle = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)newComponent));
                    }
                }
            }
        }
        if ((style = newStyle) != null && style.method_10969() != null) {
            class_2568 hoverevent = style.method_10969();
            class_2568.class_5249 hoverevent$itemstackinfo = (class_2568.class_5249)hoverevent.method_10891(class_2568.class_5247.field_24343);
            if (hoverevent$itemstackinfo != null) {
                if (style.method_10970() != null) {
                    this.isHoveringItemLink = true;
                }
                int backupWidth = this.field_22789;
                this.field_22789 /= 2;
                guiGraphics.method_51446(this.field_22787.field_1772, hoverevent$itemstackinfo.method_27683(), mouseX, mouseY);
                this.field_22789 = backupWidth;
                this.isHoveringItemLink = false;
            } else {
                class_2568.class_5248 hoverevent$entitytooltipinfo = (class_2568.class_5248)hoverevent.method_10891(class_2568.class_5247.field_24344);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.field_22787.field_1690.field_1827) {
                        guiGraphics.method_51434(this.field_22787.field_1772, hoverevent$entitytooltipinfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = (class_2561)hoverevent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        int width = this.field_22789 / 2 - mouseX - 10;
                        guiGraphics.method_51447(this.field_22787.field_1772, this.field_22787.field_1772.method_1728((class_5348)component, width), mouseX, mouseY);
                    }
                }
            }
        }
        guiGraphics.method_51448().method_22909();
    }

    public List<class_2561> getTooltipFromItem(class_1799 pItemStack) {
        List tooltip = BookContentScreen.method_25408((class_310)class_310.method_1551(), (class_1799)pItemStack);
        if (this.isHoveringItemLink) {
            tooltip.add(class_2561.method_43470((String)""));
            if (ModonomiconJeiIntegration.isJeiLoaded()) {
                tooltip.add(class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1060)));
                tooltip.add(class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info_line2").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
            } else {
                tooltip.add(class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info.no_jei").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1061)));
            }
        }
        return tooltip;
    }

    public List<class_2561> getTooltipFromFluid(FluidHolder fluidStack) {
        List<class_2561> tooltip = ClientServices.FLUID.getTooltip(fluidStack, 1000, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070), FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY);
        if (this.isHoveringItemLink) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            if (ModonomiconJeiIntegration.isJeiLoaded()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1060)));
                tooltip.add((class_2561)class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info_line2").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"modonomicon.gui.hover.item_link_info.no_jei").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1061)));
            }
        }
        return tooltip;
    }

    public boolean method_25430(@Nullable class_2583 pStyle) {
        class_2558 event;
        if (pStyle != null && (event = pStyle.method_10970()) != null) {
            Object link;
            if (event.method_10845() == class_2558.class_2559.field_11748) {
                if (BookLink.isBookLink(event.method_10844())) {
                    BookLink link2 = BookLink.from(this.getBook(), event.method_10844());
                    Book book = BookDataManager.get().getBook(link2.bookId);
                    if (link2.entryId != null) {
                        BookEntry entry = book.getEntry(link2.entryId);
                        if (!BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, entry)) {
                            return false;
                        }
                        Integer page = link2.pageNumber;
                        if (link2.pageAnchor != null) {
                            page = entry.getPageNumberForAnchor(link2.pageAnchor);
                        }
                        if (page != null && !BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, entry.getPages().get(page))) {
                            return false;
                        }
                        if (page == null) {
                            page = 0;
                        }
                        int currentPageIndex = this.unlockedPages.get(this.openPagesIndex).getPageNumber();
                        BookGuiManager.get().pushHistory(this.entry.getBook().getId(), this.entry.getCategory().getId(), this.entry.getId(), currentPageIndex);
                        BookGuiManager.get().openEntry(link2.bookId, link2.entryId, page);
                    } else if (link2.categoryId != null) {
                        BookGuiManager.get().openEntry(link2.bookId, link2.categoryId, null, 0);
                    } else {
                        BookGuiManager.get().openEntry(link2.bookId, null, null, 0);
                    }
                    return true;
                }
                if (PatchouliLink.isPatchouliLink(event.method_10844())) {
                    link = PatchouliLink.from(event.method_10844());
                    if (((PatchouliLink)link).bookId != null) {
                        this.simulateEscClosing = true;
                        Services.PATCHOULI.openEntry(((PatchouliLink)link).bookId, ((PatchouliLink)link).entryId, ((PatchouliLink)link).pageNumber);
                        return true;
                    }
                }
                if (ItemLinkRenderer.isItemLink(event.method_10844())) {
                    if (ModonomiconJeiIntegration.isJeiLoaded()) {
                        String itemId = event.method_10844().substring(ItemLinkRenderer.PROTOCOL_ITEM_LENGTH);
                        class_1799 itemStack = ItemStackUtil.loadFromParsed(ItemStackUtil.parseItemStackString(itemId));
                        this.method_25419();
                        if (class_437.method_25442()) {
                            ModonomiconJeiIntegration.showUses(itemStack);
                        } else {
                            ModonomiconJeiIntegration.showRecipe(itemStack);
                        }
                        if (!ModonomiconJeiIntegration.isJEIRecipesGuiOpen()) {
                            ClientServices.GUI.pushGuiLayer(this);
                        }
                    }
                    return true;
                }
            }
            if (event.method_10845() == class_2558.class_2559.field_11750 && CommandLink.isCommandLink(event.method_10844())) {
                link = CommandLink.from(this.getBook(), event.method_10844());
                Book book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    if (BookUnlockStateManager.get().canRunFor((class_1657)this.field_22787.field_1724, command)) {
                        Services.NETWORK.sendToServer(new ClickCommandLinkMessage(((CommandLink)link).bookId, ((CommandLink)link).commandId));
                        if (this.field_22787.method_1576() == null) {
                            BookUnlockStateManager.get().setRunFor((class_1657)this.field_22787.field_1724, command);
                        }
                    }
                    return true;
                }
            }
        }
        return super.method_25430(pStyle);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.unlockedPages = this.entry.getUnlockedPagesFor((class_1657)this.field_22787.field_1724);
        this.beginDisplayPages();
        this.method_37063(new BackButton(this, this.field_22789 / 2 - 9, this.bookTop + 180 - 4));
    }

    public void method_25393() {
        super.method_25393();
        if (!BookContentScreen.method_25442()) {
            ++this.ticksInBook;
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        class_2583 style;
        if (pButton == 0 && (style = this.getClickedComponentStyleAt(pMouseX, pMouseY)) != null && this.method_25430(style)) {
            return true;
        }
        if (super.method_25402(pMouseX, pMouseY, pButton)) {
            return true;
        }
        boolean clickPage = this.clickPage(this.leftPageRenderer, pMouseX, pMouseY, pButton) || this.clickPage(this.rightPageRenderer, pMouseX, pMouseY, pButton);
        return clickPage || super.method_25402(pMouseX, pMouseY, pButton);
    }
}

