/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.error.BookErrorHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorInfo;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class BookErrorScreen
extends class_437 {
    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    private static final class_2960 BOOK_CONTENT_TEXTURE = new class_2960("modonomicon", "textures/gui/book_content.png");
    private final Book book;
    private int bookLeft;
    private int bookTop;
    private class_2561 errorText;

    public BookErrorScreen(Book book) {
        super((class_2561)class_2561.method_43470((String)""));
        this.book = book;
        this.field_22787 = class_310.method_1551();
    }

    public void renderBookBackground(class_332 guiGraphics) {
        int x = 0;
        int y = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(BOOK_CONTENT_TEXTURE, x, y, 0.0f, 0.0f, 272, 178, 512, 256);
    }

    public void renderError(class_332 guiGraphics, class_2561 text, int x, int y, int width) {
        for (class_5481 formattedcharsequence : this.field_22793.method_1728((class_5348)text, width)) {
            guiGraphics.method_51430(this.field_22793, formattedcharsequence, x, y, 0, false);
            Objects.requireNonNull(this.field_22793);
            y += 9;
        }
    }

    public void prepareError() {
        BookErrorHolder errorHolder = BookErrorManager.get().getErrors(this.book.getId());
        if (errorHolder.getErrors().isEmpty()) {
            this.errorText = class_2561.method_43471((String)"modonomicon.gui.no_errors_found");
            Modonomicon.LOG.warn("No errors found for book {}, but error screen was opened!", (Object)this.book.getId());
        } else {
            BookErrorInfo firstError = errorHolder.getErrors().get(0);
            Object errorString = firstError.toString();
            if (errorHolder.getErrors().size() > 1) {
                errorString = (String)errorString + "\n\n(" + (errorHolder.getErrors().size() - 1) + " more errors, see log)";
            }
            this.errorText = class_2561.method_43470((String)errorString);
        }
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderBookBackground(guiGraphics);
        guiGraphics.method_51448().method_22909();
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderError(guiGraphics, this.errorText, 15, 15, 242);
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25422() {
        return true;
    }

    protected void method_25426() {
        super.method_25426();
        this.bookLeft = (this.field_22789 - 272) / 2;
        this.bookTop = (this.field_22790 - 178) / 2;
        this.prepareError();
    }
}

