/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.SaveBookStateMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class BookOverviewScreen
extends class_437 {
    private final Book book;
    private final List<BookCategory> categories;
    private final List<BookCategoryScreen> categoryScreens;
    private final int frameThicknessW = 14;
    private final int frameThicknessH = 14;
    private int currentCategory = 0;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;

    public BookOverviewScreen(Book book) {
        super((class_2561)class_2561.method_43470((String)""));
        this.field_22787 = class_310.method_1551();
        this.book = book;
        this.categories = book.getCategoriesSorted();
        this.categoryScreens = this.categories.stream().map(c -> new BookCategoryScreen(this, (BookCategory)c)).toList();
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public void onDisplay() {
        this.loadBookState();
        this.updateUnreadEntriesState();
        BookCategoryScreen currentScreen = this.categoryScreens.get(this.currentCategory);
        currentScreen.onDisplay();
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockStateManager.get().isReadFor((class_1657)this.field_22787.field_1724, (BookEntry)e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, (BookEntry)e) && !BookUnlockStateManager.get().isReadFor((class_1657)this.field_22787.field_1724, (BookEntry)e));
    }

    public BookCategoryScreen getCurrentCategoryScreen() {
        return this.categoryScreens.get(this.currentCategory);
    }

    public int getCurrentCategory() {
        return this.currentCategory;
    }

    public Book getBook() {
        return this.book;
    }

    public class_2960 getBookOverviewTexture() {
        return this.book.getBookOverviewTexture();
    }

    public int getInnerX() {
        int n = (this.field_22789 - this.getFrameWidth()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerY() {
        int n = (this.field_22790 - this.getFrameHeight()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerWidth() {
        int n = this.getFrameWidth();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getInnerHeight() {
        int n = this.getFrameHeight();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getFrameThicknessW() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameThicknessH() {
        Objects.requireNonNull(this);
        return 14;
    }

    public void changeCategory(BookCategory category) {
        int index;
        if (category == null) {
            Modonomicon.LOG.warn("Tried to change to a null category in this book ({}).", (Object)this.book.getId());
        }
        if ((index = this.categories.indexOf(category)) != -1) {
            this.changeCategory(index);
        } else {
            Modonomicon.LOG.warn("Tried to change to a category ({}) that does not exist in this book ({}).", (Object)this.book.getId(), (Object)category.getId());
        }
    }

    public void changeCategory(int categoryIndex) {
        if (this.currentCategory == categoryIndex) {
            return;
        }
        int oldIndex = this.currentCategory;
        this.currentCategory = categoryIndex;
        this.onCategoryChanged(oldIndex, this.currentCategory);
    }

    public void onCategoryChanged(int oldIndex, int newIndex) {
        BookCategoryScreen oldScreen = this.categoryScreens.get(oldIndex);
        oldScreen.onClose();
        BookCategoryScreen newScreen = this.categoryScreens.get(newIndex);
        newScreen.onDisplay();
    }

    protected int getFrameWidth() {
        return this.field_22789 - 60;
    }

    protected int getFrameHeight() {
        return this.field_22790 - 20;
    }

    protected void renderFrame(class_332 guiGraphics) {
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        int x = (this.field_22789 - width) / 2;
        int y = (this.field_22790 - height) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        GuiGraphicsExt.blitWithBorder(guiGraphics, this.book.getFrameTexture(), x, y, 0, 0, width, height, 140, 140, 50, 50, 50, 50);
        this.renderFrameOverlay(guiGraphics, this.book.getTopFrameOverlay(), x + width / 2, y);
        this.renderFrameOverlay(guiGraphics, this.book.getBottomFrameOverlay(), x + width / 2, y + height);
        this.renderFrameOverlay(guiGraphics, this.book.getLeftFrameOverlay(), x, y + height / 2);
        this.renderFrameOverlay(guiGraphics, this.book.getRightFrameOverlay(), x + width, y + height / 2);
    }

    protected void renderFrameOverlay(class_332 guiGraphics, BookFrameOverlay overlay, int x, int y) {
        if (overlay.getFrameWidth() > 0 && overlay.getFrameHeight() > 0) {
            guiGraphics.method_25302(overlay.getTexture(), overlay.getFrameX(x), overlay.getFrameY(y), overlay.getFrameU(), overlay.getFrameV(), overlay.getFrameWidth(), overlay.getFrameHeight());
        }
    }

    protected void onBookCategoryButtonClick(CategoryButton button) {
        this.changeCategory(button.getCategoryIndex());
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !class_437.method_25442()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && class_437.method_25442()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    private void loadBookState() {
        BookCategory openCategory;
        BookVisualState state = BookVisualStateManager.get().getBookStateFor((class_1657)this.field_22787.field_1724, this.book);
        if (state != null && state.openCategory != null && (openCategory = this.book.getCategory(state.openCategory)) != null) {
            this.currentCategory = this.categories.indexOf(openCategory);
        }
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        this.getCurrentCategoryScreen().mouseClicked(pMouseX, pMouseY, pButton);
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.getCurrentCategoryScreen().mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        this.getCurrentCategoryScreen().zoom(pDelta);
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        this.method_25420(guiGraphics);
        this.getCurrentCategoryScreen().renderBackground(guiGraphics);
        this.getCurrentCategoryScreen().render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderFrame(guiGraphics);
        this.getCurrentCategoryScreen().renderEntryTooltips(guiGraphics, pMouseX, pMouseY, pPartialTick);
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        this.getCurrentCategoryScreen().onClose();
        Services.NETWORK.sendToServer(new SaveBookStateMessage(this.book, this.getCurrentCategoryScreen().getCategory().getId()));
        BookGuiManager.get().resetHistory();
        BookGuiManager.get().openOverviewScreen = null;
        super.method_25419();
    }

    public boolean method_25430(@Nullable class_2583 pStyle) {
        return super.method_25430(pStyle);
    }

    public void onSyncBookUnlockCapabilityMessage(SyncBookUnlockStatesMessage message) {
        this.method_41843();
        this.updateUnreadEntriesState();
    }

    protected void method_25426() {
        super.method_25426();
        BookGuiManager.get().openOverviewScreen = this;
        int buttonXOffset = -11;
        int buttonYOffset = 30 + this.getBook().getCategoryButtonYOffset();
        int buttonX = (this.field_22789 - this.getFrameWidth()) / 2 - this.getFrameThicknessW() + buttonXOffset;
        int buttonY = (this.field_22790 - this.getFrameHeight()) / 2 - this.getFrameThicknessH() + buttonYOffset;
        int buttonWidth = (this.field_22789 - this.getFrameWidth()) / 2 + buttonXOffset + 6;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonCount = 0;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            if (!this.categories.get(i).showCategoryButton() || !BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, this.categories.get(i))) continue;
            CategoryButton button = new CategoryButton(this, this.categories.get(i), i, buttonX, buttonY + (buttonHeight + buttonSpacing) * buttonCount, buttonWidth, buttonHeight, b -> this.onBookCategoryButtonClick((CategoryButton)b), class_7919.method_47407((class_2561)class_2561.method_43471((String)this.categories.get(i).getName())));
            this.method_37063((class_364)button);
            ++buttonCount;
        }
        int readAllButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 - 3;
        int readAllButtonYOffset = 30 + this.getBook().getReadAllButtonYOffset();
        int readAllButtonY = (this.field_22790 - this.getFrameHeight()) / 2 + 7 + readAllButtonYOffset;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b));
        this.method_37063((class_364)readAllButton);
        int searchButtonXOffset = 7;
        int searchButtonYOffset = -30 + this.getBook().getSearchButtonYOffset();
        int searchButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + searchButtonXOffset;
        int searchButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 + searchButtonYOffset;
        int searchButtonWidth = 44;
        int scissorX = this.getFrameWidth() + this.getFrameThicknessW() * 2 + 2;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), class_7919.method_47407((class_2561)class_2561.method_43471((String)"modonomicon.gui.open_search")));
        this.method_37063((class_364)searchButton);
    }

    protected void onSearchButtonClick(SearchButton button) {
        ClientServices.GUI.pushGuiLayer(new BookSearchScreen(this));
    }

    public boolean method_25421() {
        return false;
    }
}

