/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ColorLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.CommandLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ItemLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.PatchouliLinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentStrikethroughExtension;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ext.ComponentUnderlineExtension;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.List;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;

public class BookTextRenderer {
    private final Parser markdownParser;
    private final List<Extension> extensions = List.of(ComponentStrikethroughExtension.create(), ComponentUnderlineExtension.create());
    private final Book book;

    public BookTextRenderer(Book book) {
        this.markdownParser = Parser.builder().extensions(this.extensions).build();
        this.book = book;
    }

    public List<class_5250> render(String markdown) {
        return this.render(markdown, class_2583.field_24360);
    }

    public List<class_5250> render(String markdown, class_2583 defaultStyle) {
        ComponentRenderer renderer = new ComponentRenderer.Builder().renderSoftLineBreaks(false).replaceSoftLineBreaksWithSpace(true).linkColor(class_5251.method_27717((int)0x5555FF)).linkRenderers(List.of(new ColorLinkRenderer(), new BookLinkRenderer(), new ItemLinkRenderer(), new PatchouliLinkRenderer(), new CommandLinkRenderer())).style(defaultStyle.method_27704(BookDataManager.Client.get().safeFont(this.book.getFont()))).extensions(this.extensions).build();
        Node document = this.markdownParser.parse(markdown);
        return renderer.render(document, this.book);
    }
}

