/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.commonmark.internal.renderer.text.BulletListHolder;
import org.commonmark.internal.renderer.text.ListHolder;
import org.commonmark.internal.renderer.text.OrderedListHolder;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BulletList;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.NodeRenderer;

public class CoreComponentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final ComponentNodeRendererContext context;

    public CoreComponentNodeRenderer(ComponentNodeRendererContext context) {
        this.context = context;
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        ObjectOpenHashSet classes = new ObjectOpenHashSet(Arrays.asList(Document.class, Heading.class, Paragraph.class, BulletList.class, Link.class, ListItem.class, OrderedList.class, Emphasis.class, StrongEmphasis.class, Text.class, SoftLineBreak.class, HardLineBreak.class));
        classes.trim();
        return classes;
    }

    public void render(Node node) {
        node.accept((Visitor)this);
    }

    public void visit(BulletList bulletList) {
        ListItem item;
        this.context.setListHolder((ListHolder)new BulletListHolder(this.context.getListHolder(), bulletList));
        this.visitChildren((Node)bulletList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = bulletList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    public void visit(Emphasis emphasis) {
        boolean italic = this.context.getCurrentStyle().method_10966();
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_10978(Boolean.valueOf(true)));
        this.visitChildren((Node)emphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_10978(Boolean.valueOf(italic)));
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.context.getCurrentComponent().method_10852((class_2561)class_2561.method_43470((String)"\n"));
        this.visitChildren((Node)hardLineBreak);
    }

    public void visit(Link link) {
        for (LinkRenderer renderer : this.context.getLinkRenderers()) {
            if (!renderer.visit(link, this::visitChildren, this.context)) continue;
            return;
        }
        class_5251 currentColor = this.context.getCurrentStyle().method_10973();
        class_5250 hoverComponent = class_2561.method_43469((String)"modonomicon.gui.hover.http_link", (Object[])new Object[]{link.getDestination()});
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_27703(currentColor == null ? this.context.getLinkColor() : currentColor).method_10958(new class_2558(class_2558.class_2559.field_11749, link.getDestination())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverComponent)));
        this.visitChildren((Node)link);
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_27703(currentColor).method_10958(null).method_10949(null));
    }

    public void visit(ListItem listItem) {
        this.context.finalizeCurrentComponent();
        ListHolder listHolder = this.context.getListHolder();
        if (listHolder != null && listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)listHolder;
            this.context.getCurrentComponent().method_10852((class_2561)class_2561.method_43471((String)(orderedListHolder.getIndent() + orderedListHolder.getCounter() + orderedListHolder.getDelimiter() + " ")).method_27696(class_2583.field_24360).method_27694(s -> s.method_27704(this.context.getCurrentStyle().method_27708())));
            this.visitChildren((Node)listItem);
            orderedListHolder.increaseCounter();
        } else if (listHolder != null && listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)listHolder;
            this.context.getCurrentComponent().method_10852((class_2561)class_2561.method_43471((String)(bulletListHolder.getIndent() + bulletListHolder.getMarker() + " ")).method_27696(class_2583.field_24360).method_27694(s -> s.method_27704(this.context.getCurrentStyle().method_27708())));
            this.visitChildren((Node)listItem);
        }
    }

    public void visit(OrderedList orderedList) {
        ListItem item;
        this.context.setListHolder((ListHolder)new OrderedListHolder(this.context.getListHolder(), orderedList));
        this.visitChildren((Node)orderedList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = orderedList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    public void visit(SoftLineBreak softLineBreak) {
        if (this.context.getRenderSoftLineBreaks()) {
            this.context.getCurrentComponent().method_27693("\n");
        } else if (this.context.getReplaceSoftLineBreaksWithSpace()) {
            this.context.getCurrentComponent().method_10852((class_2561)class_2561.method_43470((String)" "));
        }
        this.visitChildren((Node)softLineBreak);
    }

    public void visit(StrongEmphasis strongEmphasis) {
        boolean emphasis = this.context.getCurrentStyle().method_10984();
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_10982(Boolean.valueOf(true)));
        this.visitChildren((Node)strongEmphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().method_10982(Boolean.valueOf(emphasis)));
    }

    public void visit(Text text) {
        this.context.getCurrentComponent().method_10852((class_2561)class_2561.method_43471((String)text.getLiteral()).method_27696(this.context.getCurrentStyle()));
        this.visitChildren((Node)text);
    }

    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

