/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_827;
import net.minecraft.class_898;
import org.joml.Matrix4f;

public class MultiblockPreviewRenderer {
    public static boolean hasMultiblock;
    private static Map<class_2338, class_2586> blockEntityCache;
    private static Set<class_2586> erroredBlockEntities;
    private static Multiblock multiblock;
    private static class_2561 name;
    private static class_2338 pos;
    private static boolean isAnchored;
    private static class_2470 facingRotation;
    private static Function<class_2338, class_2338> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static class_2680 lookingState;
    private static class_2338 lookingPos;
    private static class_4597.class_4598 buffers;

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip) {
        MultiblockPreviewRenderer.setMultiblock(multiblock, name, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip, Function<class_2338, class_2338> offsetApplier) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockPreviewRenderer.multiblock = multiblock;
            blockEntityCache = new HashMap<class_2338, class_2586>();
            erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
            MultiblockPreviewRenderer.name = name;
            MultiblockPreviewRenderer.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    public static void onRenderHUD(class_332 guiGraphics, float partialTicks) {
        if (hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : partialTicks);
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, -Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed, 0.0f);
            class_310 mc = class_310.method_1551();
            int x = mc.method_22683().method_4486() / 2;
            int y = 12;
            GuiGraphicsExt.drawString(guiGraphics, mc.field_1772, name, (float)x - (float)mc.field_1772.method_27525((class_5348)name) / 2.0f, (float)y, 0xFFFFFF, false);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = class_1074.method_4662((String)"modonomicon.multiblock.complete", (Object[])new Object[0]);
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, Math.min((float)(height + 5), animTime), 0.0f);
                guiGraphics.method_51433(mc.field_1772, s, (int)((float)x - (float)mc.field_1772.method_1727(s) / 2.0f), top + height - 10, 65280, false);
                guiGraphics.method_51448().method_22909();
            }
            guiGraphics.method_25294(left - 1, top - 1, left + width + 1, top + height + 1, -16777216);
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + width, top + height, -10066330, -11184811);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = class_3532.method_15369((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            MultiblockPreviewRenderer.drawGradientRect(guiGraphics, left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = class_1074.method_4662((String)"modonomicon.multiblock.not_anchored", (Object[])new Object[0]);
                guiGraphics.method_51433(mc.field_1772, s, (int)((float)x - (float)mc.field_1772.method_1727(s) / 2.0f), top + height + 8, 0xFFFFFF, false);
            } else {
                if (lookingState != null) {
                    try {
                        class_2248 block = lookingState.method_26204();
                        class_1799 stack = block.method_9574((class_1922)mc.field_1687, lookingPos, lookingState);
                        if (!stack.method_7960()) {
                            guiGraphics.method_51439(mc.field_1772, stack.method_7964(), left + 20, top + height + 8, 0xFFFFFF, false);
                            guiGraphics.method_51427(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    float mult = 1.0f;
                    Object progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = class_1074.method_4662((String)"modonomicon.multiblock.remove_blocks", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2.0f;
                        posx -= width / 2;
                        posy += 2;
                    }
                    guiGraphics.method_51433(mc.field_1772, (String)progress, (int)((float)posx - (float)mc.field_1772.method_1727((String)progress) / mult), posy, color, true);
                }
            }
            guiGraphics.method_51448().method_22909();
        }
    }

    public static void onRenderLevelLastEvent(class_4587 poseStack) {
        if (hasMultiblock && multiblock != null) {
            MultiblockPreviewRenderer.renderMultiblock((class_1937)class_310.method_1551().field_1687, poseStack);
        }
    }

    public static void anchorTo(class_2338 target, class_2470 rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (hasMultiblock && !isAnchored && player == class_310.method_1551().field_1724) {
            MultiblockPreviewRenderer.anchorTo(hit.method_17777(), MultiblockPreviewRenderer.getRotation((class_1297)player));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void onClientTick(class_310 mc) {
        if (class_310.method_1551().field_1687 == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(class_1937 level, class_4587 ms) {
        class_310 mc = class_310.method_1551();
        if (!isAnchored) {
            facingRotation = MultiblockPreviewRenderer.getRotation((class_1297)mc.field_1724);
            if (mc.field_1765 instanceof class_3965) {
                pos = ((class_3965)mc.field_1765).method_17777();
            }
        } else if (pos.method_19770((class_2374)mc.field_1724.method_19538()) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = class_2470.field_11467;
        }
        multiblock.setLevel(level);
        class_898 erd = mc.method_1561();
        double renderPosX = erd.field_4686.method_19326().method_10216();
        double renderPosY = erd.field_4686.method_19326().method_10214();
        double renderPosZ = erd.field_4686.method_19326().method_10215();
        ms.method_22903();
        ms.method_22904(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockPreviewRenderer.initBuffers(mc.method_22940().method_23000());
        }
        class_2338 checkPos = null;
        class_239 class_2392 = mc.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockRes = (class_3965)class_2392;
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }
        airFilled = 0;
        blocksDone = 0;
        blocks = 0;
        lookingState = null;
        lookingPos = checkPos;
        Pair<class_2338, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate(level, MultiblockPreviewRenderer.getStartPos(), MultiblockPreviewRenderer.getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : (Collection)sim.getSecond()) {
            boolean air;
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                lookingState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks);
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            if (r.getStateMatcher().equals(Matchers.ANY) || r.getStateMatcher().getType() == DisplayOnlyMatcher.TYPE) continue;
            boolean bl = air = !r.getStateMatcher().countsTowardsTotalBlocks();
            if (!air) {
                ++blocks;
            }
            if (!r.test(level, facingRotation)) {
                class_2680 renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);
                MultiblockPreviewRenderer.renderBlock(level, renderState, r.getWorldPosition(), multiblock, air, alpha, ms);
                class_2248 class_22482 = renderState.method_26204();
                if (class_22482 instanceof class_2343) {
                    class_2343 eb = (class_2343)class_22482;
                    class_2586 be = blockEntityCache.computeIfAbsent(r.getWorldPosition().method_10062(), p -> eb.method_10123(p, renderState));
                    if (be != null && !erroredBlockEntities.contains(be)) {
                        be.method_31662((class_1937)mc.field_1687);
                        be.method_31664(renderState);
                        ms.method_22903();
                        class_2338 bePos = r.getWorldPosition();
                        ms.method_46416((float)bePos.method_10263(), (float)bePos.method_10264(), (float)bePos.method_10260());
                        try {
                            class_827 renderer = class_310.method_1551().method_31975().method_3550(be);
                            if (renderer != null) {
                                renderer.method_3569(be, ClientTicks.partialTicks, ms, (class_4597)buffers, 0xF000F0, class_4608.field_21444);
                            }
                        }
                        catch (Exception e) {
                            erroredBlockEntities.add(be);
                            Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
                        }
                        ms.method_22909();
                    }
                }
                if (!air) continue;
                ++airFilled;
                continue;
            }
            if (air) continue;
            ++blocksDone;
        }
        buffers.method_22993();
        ms.method_22909();
        if (!isAnchored) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(class_1937 world, class_2680 state, class_2338 pos, Multiblock multiblock, boolean isAir, float alpha, class_4587 ms) {
        if (pos != null) {
            ms.method_22903();
            ms.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            if (state.method_26204() == class_2246.field_10124) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.method_46416(off, off, off);
                ms.method_22905(scale, scale, scale);
                state = class_2246.field_10058.method_9564();
            }
            ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ms, (class_4597)buffers, world.method_8409());
            ms.method_22909();
        }
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static class_2470 getFacingRotation() {
        return multiblock.isSymmetrical() ? class_2470.field_11467 : facingRotation;
    }

    public static class_2338 getStartPos() {
        return offsetApplier.apply(pos);
    }

    private static void drawGradientRect(class_332 guiGraphics, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f mat = guiGraphics.method_51448().method_23760().method_23761();
        bufferbuilder.method_22918(mat, (float)right, (float)top, 0.0f).method_22915(f1, f2, f3, f).method_1344();
        bufferbuilder.method_22918(mat, (float)left, (float)top, 0.0f).method_22915(f1, f2, f3, f).method_1344();
        bufferbuilder.method_22918(mat, (float)left, (float)bottom, 0.0f).method_22915(f5, f6, f7, f4).method_1344();
        bufferbuilder.method_22918(mat, (float)right, (float)bottom, 0.0f).method_22915(f5, f6, f7, f4).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    private static class_2470 getRotation(class_1297 entity) {
        return AbstractMultiblock.rotationFromFacing(entity.method_5735());
    }

    private static class_4597.class_4598 initBuffers(class_4597.class_4598 original) {
        class_287 fallback = original.field_20952;
        Map layerBuffers = original.field_20953;
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderLayer.remap((class_1921)e.getKey()), (class_287)e.getValue());
        }
        return new GhostBuffers(fallback, (Map<class_1921, class_287>)remapped);
    }

    static {
        blockEntityCache = new Object2ObjectOpenHashMap();
        erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
        buffers = null;
    }

    private static class GhostRenderLayer
    extends class_1921 {
        private static final Map<class_1921, class_1921> remappedTypes = new IdentityHashMap<class_1921, class_1921>();

        private GhostRenderLayer(class_1921 original) {
            super(String.format("%s_%s_ghost", original.toString(), "modonomicon"), original.method_23031(), original.method_23033(), original.method_22722(), original.method_23037(), true, () -> {
                original.method_23516();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.method_23518();
            });
        }

        public static class_1921 remap(class_1921 in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends class_4597.class_4598 {
        protected GhostBuffers(class_287 fallback, Map<class_1921, class_287> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public class_4588 getBuffer(class_1921 type) {
            return super.getBuffer(GhostRenderLayer.remap(type));
        }
    }
}

