/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.VisualizeButton;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class BookMultiblockPageRenderer
extends BookPageRenderer<BookMultiblockPage>
implements PageWithTextRenderer {
    private static final class_5819 randomSource = class_5819.method_43053();
    private final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap();
    private final Set<class_2586> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    protected Pair<class_2338, Collection<Multiblock.SimulateResult>> multiblockSimulation;
    protected class_4185 visualizeButton;

    public BookMultiblockPageRenderer(BookMultiblockPage page) {
        super(page);
    }

    public void handleButtonVisualize(class_4185 button) {
        MultiblockPreviewRenderer.setMultiblock(((BookMultiblockPage)this.page).getMultiblock(), ((BookMultiblockPage)this.page).getMultiblockName().getComponent(), true);
        this.parentScreen.simulateEscClosing = true;
        this.parentScreen.method_25419();
    }

    private void renderMultiblock(class_332 guiGraphics) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_2338 pos = class_2338.field_10980;
        class_2470 facingRotation = class_2470.field_11467;
        ((BookMultiblockPage)this.page).getMultiblock().setLevel((class_1937)level);
        if (((BookMultiblockPage)this.page).getMultiblock().isSymmetrical()) {
            facingRotation = class_2470.field_11467;
        }
        class_2382 size = ((BookMultiblockPage)this.page).getMultiblock().getSize();
        int sizeX = size.method_10263();
        int sizeY = size.method_10264();
        int sizeZ = size.method_10260();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 62;
        int yPos = 60;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)xPos, (float)yPos, 100.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.method_51448().method_22907(class_7833.field_40714.rotationDegrees(-30.0f));
        rotMat.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parentScreen.ticksInBook * 0.5f;
        if (!class_437.method_25442()) {
            time += ClientTicks.partialTicks;
        }
        guiGraphics.method_51448().method_46416(-offX, 0.0f, -offZ);
        guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(time));
        rotMat.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-time));
        guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        rotMat.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-45.0f));
        guiGraphics.method_51448().method_46416(offX, 0.0f, offZ);
        rotMat.transform(eye);
        eye.div(eye.w);
        class_4597.class_4598 buffers = mc.method_22940().method_23000();
        class_2338 checkPos = null;
        class_239 class_2392 = mc.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockRes = (class_3965)class_2392;
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        for (Multiblock.SimulateResult r : (Collection)this.multiblockSimulation.getSecond()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            class_2680 renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);
            this.renderBlock(buffers, level, renderState, r.getWorldPosition(), alpha, guiGraphics.method_51448());
            class_2248 class_22482 = renderState.method_26204();
            if (!(class_22482 instanceof class_2343)) continue;
            class_2343 eb = (class_2343)class_22482;
            class_2586 be = this.blockEntityCache.computeIfAbsent(r.getWorldPosition().method_10062(), p -> eb.method_10123(p, renderState));
            if (be == null || this.erroredBlockEntities.contains(be)) continue;
            be.method_31662((class_1937)mc.field_1687);
            be.method_31664(renderState);
            guiGraphics.method_51448().method_22903();
            class_2338 bePos = r.getWorldPosition();
            guiGraphics.method_51448().method_46416((float)bePos.method_10263(), (float)bePos.method_10264(), (float)bePos.method_10260());
            try {
                class_827 renderer = class_310.method_1551().method_31975().method_3550(be);
                if (renderer != null) {
                    renderer.method_3569(be, ClientTicks.partialTicks, guiGraphics.method_51448(), (class_4597)buffers, 0xF000F0, class_4608.field_21444);
                }
            }
            catch (Exception e) {
                this.erroredBlockEntities.add(be);
                Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
            }
            guiGraphics.method_51448().method_22909();
        }
        guiGraphics.method_51448().method_22909();
        buffers.method_22993();
        guiGraphics.method_51448().method_22909();
    }

    private void renderBlock(class_4597.class_4598 buffers, class_638 level, class_2680 state, class_2338 pos, float alpha, class_4587 ps) {
        if (pos != null) {
            ps.method_22903();
            ps.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            ClientServices.MULTIBLOCK.renderBlock(state, pos, ((BookMultiblockPage)this.page).getMultiblock(), ps, (class_4597)buffers, randomSource);
            ps.method_22909();
        }
    }

    @Override
    public int getTextY() {
        return 115;
    }

    @Override
    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.multiblockSimulation = ((BookMultiblockPage)this.page).getMultiblock().simulate(null, class_2338.field_10980, class_2470.field_11467, true, true);
        if (((BookMultiblockPage)this.page).showVisualizeButton()) {
            this.visualizeButton = new VisualizeButton(this.parentScreen, 13, 102, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float ticks) {
        int x = 9;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentScreen.drawFromTexture(guiGraphics, ((BookMultiblockPage)this.page).getBook(), x, y, 405, 149, 106, 106);
        if (!((BookMultiblockPage)this.page).getMultiblockName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookMultiblockPage)this.page).getMultiblockName(), false, 62, 0);
        }
        this.renderMultiblock(guiGraphics);
        this.renderBookTextHolder(guiGraphics, ((BookMultiblockPage)this.page).getText(), 0, this.getTextY(), 124);
        class_2583 style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            class_2583 multiblockNameStyle = this.getClickedComponentStyleAtForTitle(((BookMultiblockPage)this.page).getMultiblockName(), 62, 0, pMouseX, pMouseY);
            if (multiblockNameStyle != null) {
                return multiblockNameStyle;
            }
            class_2583 textStyle = this.getClickedComponentStyleAtForTextHolder(((BookMultiblockPage)this.page).getText(), 0, this.getTextY(), 124, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }
}

