/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookFalseConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class FormattingCategoryProvider
extends CategoryProvider {
    public FormattingCategoryProvider(BookProvider parent) {
        super(parent, "formatting");
    }

    @Override
    protected String[] generateEntryMap() {
        return new String[]{"_____________________", "__b___a______________", "__________l_____x____", "_____________________", "_____________________"};
    }

    @Override
    protected void generateEntries() {
        BookEntryModel basicFormattingEntry = this.add(this.makeBasicFormattingEntry('b'));
        BookEntryModel advancedFormattingEntry = this.add(this.makeAdvancedFormattingEntry('a'));
        BookEntryModel linkFormattingEntry = this.add(this.makeLinkFormattingEntry('l'));
        BookEntryModel alwaysLockedEntry = this.add(this.makeAlwaysLockedEntry('x'));
        alwaysLockedEntry.withCondition(BookFalseConditionModel.builder().build());
        linkFormattingEntry.withParent(this.parent(advancedFormattingEntry));
        advancedFormattingEntry.withParent(this.parent(basicFormattingEntry));
    }

    @Override
    protected BookCategoryModel generateCategory() {
        return BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName()).withIcon(new class_2960("minecraft:textures/item/book.png"));
    }

    private BookEntryModel makeBasicFormattingEntry(char location) {
        this.context().entry("basic");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        BookEntryModel formattingEntry = this.entry(location).withIcon(new class_2960("minecraft:textures/item/paper.png")).withPage(page1).withPage(page2);
        return formattingEntry;
    }

    private BookEntryModel makeAdvancedFormattingEntry(char location) {
        this.context().entry("advanced");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(this.context().pageText()).build();
        this.context().page("page3");
        BookTextPageModel page3 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        BookEntryModel formattingEntry = this.entry(location).withIcon((class_1935)class_1802.field_8153).withEntryBackground(0, 1).withPage(page1).withPage(page2).withPage(page3);
        return formattingEntry;
    }

    private BookEntryModel makeLinkFormattingEntry(char location) {
        this.context().entry("link");
        this.context().page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("page3");
        BookTextPageModel page3 = BookTextPageModel.builder().withText(this.context().pageText()).withTitle(this.context().pageTitle()).build();
        this.context().page("invalidLink");
        BookTextPageModel invalidLink = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.lang().add(this.context().pageTitle(), "Invalid Link");
        this.lang().add(this.context().pageText(), this.format("{0}", this.entryLink("It has an invalid Link", "a_cat", "an_entry")));
        return this.entry(location).withIcon((class_1935)class_1802.field_8674).withEntryBackground(0, 2).withPages(page1, page2, page3, invalidLink);
    }

    private BookEntryModel makeAlwaysLockedEntry(char location) {
        this.context().entry("always_locked");
        BookEntryModel entry = this.entry(location).withIcon((class_1935)class_1802.field_8137).withLocation(this.entryMap().get(Character.valueOf(location))).withEntryBackground(0, 1);
        return entry;
    }
}

