/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_6539;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiblock
implements Multiblock {
    private final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap();
    public class_2960 id;
    protected int offX;
    protected int offY;
    protected int offZ;
    protected int viewOffX;
    protected int viewOffY;
    protected int viewOffZ;
    protected boolean symmetrical;
    class_1937 level;

    public static Map<Character, StateMatcher> mappingFromJson(JsonObject jsonMapping) {
        HashMap<Character, StateMatcher> mapping = new HashMap<Character, StateMatcher>();
        for (Map.Entry entry : jsonMapping.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Mapping key needs to be only 1 character");
            }
            char key = ((String)entry.getKey()).charAt(0);
            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_2960 stateMatcherType = class_2960.method_12829((String)class_3518.method_15265((JsonObject)value, (String)"type"));
            StateMatcher stateMatcher = LoaderRegistry.getStateMatcherJsonLoader(stateMatcherType).fromJson(value);
            mapping.put(Character.valueOf(key), stateMatcher);
        }
        return mapping;
    }

    public static <T extends AbstractMultiblock> T additionalPropertiesFromJson(T multiblock, JsonObject json) {
        if (json.has("symmetrical")) {
            multiblock.symmetrical = class_3518.method_15270((JsonObject)json, (String)"symmetrical");
        }
        if (json.has("offset")) {
            JsonArray jsonOffset = class_3518.method_15261((JsonObject)json, (String)"offset");
            if (jsonOffset.size() != 3) {
                throw new JsonSyntaxException("Offset needs to be an array of 3 integers");
            }
            multiblock.offset(jsonOffset.get(0).getAsInt(), jsonOffset.get(1).getAsInt(), jsonOffset.get(2).getAsInt());
        }
        return multiblock;
    }

    public static class_2470 fixHorizontal(class_2470 rot) {
        return switch (rot) {
            case class_2470.field_11463 -> class_2470.field_11465;
            case class_2470.field_11465 -> class_2470.field_11463;
            default -> rot;
        };
    }

    public static class_2470 rotationFromFacing(class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11034 -> class_2470.field_11463;
            case class_2350.field_11035 -> class_2470.field_11464;
            case class_2350.field_11039 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        };
    }

    public Multiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    public Multiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public void setLevel(class_1937 level) {
        this.level = level;
    }

    @Override
    public Multiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    @Override
    public Multiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    @Override
    public Multiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public Multiblock setId(class_2960 res) {
        this.id = res;
        return this;
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public void place(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setLevel(world);
        ((Collection)this.simulate(world, pos, rotation, false, false).getSecond()).forEach(r -> {
            class_2338 placePos = r.getWorldPosition();
            class_2680 targetState = r.getStateMatcher().getDisplayedState(world.method_8510()).method_26186(rotation);
            if (!targetState.method_26215() && targetState.method_26184((class_4538)world, placePos) && world.method_8320(placePos).method_45474()) {
                world.method_8501(placePos, targetState);
            }
        });
    }

    @Override
    public class_2470 validate(class_1937 world, class_2338 pos) {
        if (this.isSymmetrical() && this.validate(world, pos, class_2470.field_11467)) {
            return class_2470.field_11467;
        }
        for (class_2470 rot : class_2470.values()) {
            if (!this.validate(world, pos, rot)) continue;
            return rot;
        }
        return null;
    }

    @Override
    public boolean validate(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setLevel(world);
        Pair<class_2338, Collection<Multiblock.SimulateResult>> sim = this.simulate(world, pos, rotation, false, false);
        return ((Collection)sim.getSecond()).stream().allMatch(r -> {
            class_2338 checkPos = r.getWorldPosition();
            TriPredicate<class_1922, class_2338, class_2680> pred = r.getStateMatcher().getStatePredicate();
            class_2680 state = world.method_8320(checkPos).method_26186(AbstractMultiblock.fixHorizontal(rotation));
            return pred.test((class_1922)world, checkPos, state);
        });
    }

    @Override
    public abstract class_2382 getSize();

    @Override
    public class_2382 getOffset() {
        return new class_2382(this.offX, this.offY, this.offZ);
    }

    @Override
    public class_2382 getViewOffset() {
        return new class_2382(this.viewOffX, this.viewOffY, this.viewOffZ);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMultiblock that = (AbstractMultiblock)o;
        return this.id.equals((Object)that.id);
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        class_2680 state = this.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2343) {
            class_2343 eb = (class_2343)class_22482;
            return this.blockEntityCache.computeIfAbsent(pos.method_10062(), p -> eb.method_10123(p, state));
        }
        return null;
    }

    public class_3610 method_8316(class_2338 pos) {
        return class_3612.field_15906.method_15785();
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return 1.0f;
    }

    public class_3568 method_22336() {
        return null;
    }

    public int method_23752(class_2338 pos, class_6539 color) {
        class_1959 plains = (class_1959)this.level.method_30349().method_30530(class_7924.field_41236).method_31140(class_1972.field_9451);
        return color.getColor(plains, (double)pos.method_10263(), (double)pos.method_10260());
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    public int method_31605() {
        return 255;
    }

    public int method_31607() {
        return 0;
    }
}

