/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.SimulateResultImpl;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class DenseMultiblock
extends AbstractMultiblock {
    public static final class_2960 TYPE = Modonomicon.loc("dense");
    private static final Gson GSON = new GsonBuilder().create();
    private final String[][] pattern;
    private final class_2382 size;
    private final Map<Character, StateMatcher> targets;
    private StateMatcher[][][] stateMatchers;

    public DenseMultiblock(String[][] pattern, Map<Character, StateMatcher> targets) {
        this.pattern = pattern;
        this.targets = targets;
        if (!targets.containsKey(Character.valueOf('_'))) {
            targets.put(Character.valueOf('_'), Matchers.ANY);
        }
        if (!targets.containsKey(Character.valueOf(' '))) {
            targets.put(Character.valueOf(' '), Matchers.AIR);
        }
        if (!targets.containsKey(Character.valueOf('0'))) {
            targets.put(Character.valueOf('0'), Matchers.AIR);
        }
        this.size = this.build(targets, DenseMultiblock.getPatternDimensions(pattern));
    }

    public static DenseMultiblock fromNetwork(class_2540 buffer) {
        boolean symmetrical = buffer.readBoolean();
        int offX = buffer.method_10816();
        int offY = buffer.method_10816();
        int offZ = buffer.method_10816();
        int viewOffX = buffer.method_10816();
        int viewOffY = buffer.method_10816();
        int viewOffZ = buffer.method_10816();
        int sizeX = buffer.method_10816();
        int sizeY = buffer.method_10816();
        String[][] pattern = new String[sizeY][sizeX];
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                pattern[y][x] = buffer.method_19772();
            }
        }
        Object2ObjectOpenHashMap targets = new Object2ObjectOpenHashMap();
        int targetCount = buffer.method_10816();
        for (int i = 0; i < targetCount; ++i) {
            char key = buffer.readChar();
            class_2960 type = buffer.method_10810();
            StateMatcher stateMatcher = LoaderRegistry.getStateMatcherNetworkLoader(type).fromNetwork(buffer);
            targets.put((Object)Character.valueOf(key), (Object)stateMatcher);
        }
        DenseMultiblock multiblock = new DenseMultiblock(pattern, (Map<Character, StateMatcher>)targets);
        multiblock.setSymmetrical(symmetrical);
        multiblock.setOffset(offX, offY, offZ);
        multiblock.setViewOffset(viewOffX, viewOffY, viewOffZ);
        return multiblock;
    }

    public static DenseMultiblock fromJson(JsonObject json) {
        String[][] pattern = (String[][])GSON.fromJson(json.get("pattern"), String[][].class);
        JsonObject jsonMapping = class_3518.method_15296((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = DenseMultiblock.mappingFromJson(jsonMapping);
        DenseMultiblock multiblock = new DenseMultiblock(pattern, mapping);
        return DenseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    private static class_2382 getPatternDimensions(String[][] pattern) {
        int expectedLenX = -1;
        int expectedLenZ = -1;
        for (String[] arr : pattern) {
            if (expectedLenX == -1) {
                expectedLenX = arr.length;
            }
            if (arr.length != expectedLenX) {
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
            for (String s : arr) {
                if (expectedLenZ == -1) {
                    expectedLenZ = s.length();
                }
                if (s.length() == expectedLenZ) continue;
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + s.length());
            }
        }
        return new class_2382(expectedLenX, pattern.length, expectedLenZ);
    }

    private class_2382 build(Map<Character, StateMatcher> stateMap, class_2382 dimensions) {
        boolean foundCenter = false;
        this.stateMatchers = new StateMatcher[dimensions.method_10263()][dimensions.method_10264()][dimensions.method_10260()];
        for (int y = 0; y < dimensions.method_10264(); ++y) {
            for (int x = 0; x < dimensions.method_10263(); ++x) {
                for (int z = 0; z < dimensions.method_10260(); ++z) {
                    char c = this.pattern[y][x].charAt(z);
                    if (!stateMap.containsKey(Character.valueOf(c))) {
                        throw new IllegalArgumentException("Character " + c + " isn't mapped");
                    }
                    StateMatcher matcher = stateMap.get(Character.valueOf(c));
                    if (c == '0') {
                        if (foundCenter) {
                            throw new IllegalArgumentException("A structure can't have two centers");
                        }
                        foundCenter = true;
                        this.offX = x;
                        this.offY = dimensions.method_10264() - y - 1;
                        this.offZ = z;
                        this.setViewOffset();
                    }
                    this.stateMatchers[x][dimensions.method_10264() - y - 1][z] = matcher;
                }
            }
        }
        if (!foundCenter) {
            throw new IllegalArgumentException("A structure can't have no center");
        }
        return dimensions;
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public Pair<class_2338, Collection<Multiblock.SimulateResult>> simulate(class_1937 level, class_2338 anchor, class_2470 rotation, boolean forView, boolean disableOffset) {
        class_2338 disp;
        class_2338 class_23382 = disp = forView ? new class_2338(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).method_10070(rotation) : new class_2338(-this.offX, -this.offY, -this.offZ).method_10070(rotation);
        if (disableOffset) {
            disp = class_2338.field_10980;
        }
        class_2338 origin = anchor.method_10081((class_2382)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (int x = 0; x < this.size.method_10263(); ++x) {
            for (int y = 0; y < this.size.method_10264(); ++y) {
                for (int z = 0; z < this.size.method_10260(); ++z) {
                    class_2338 currDisp = new class_2338(x, y, z).method_10070(rotation);
                    class_2338 actionPos = origin.method_10081((class_2382)currDisp);
                    char currC = this.pattern[y][x].charAt(z);
                    ret.add(new SimulateResultImpl(actionPos, this.stateMatchers[x][y][z], Character.valueOf(currC)));
                }
            }
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(class_1937 level, class_2338 start, int x, int y, int z, class_2470 rotation) {
        this.setLevel(level);
        if (x < 0 || y < 0 || z < 0 || x >= this.size.method_10263() || y >= this.size.method_10264() || z >= this.size.method_10260()) {
            return false;
        }
        class_2338 checkPos = start.method_10081((class_2382)new class_2338(x, y, z).method_10070(AbstractMultiblock.fixHorizontal(rotation)));
        TriPredicate<class_1922, class_2338, class_2680> pred = this.stateMatchers[x][y][z].getStatePredicate();
        class_2680 state = level.method_8320(checkPos).method_26186(rotation);
        return pred.test((class_1922)level, checkPos, state);
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.method_10804(this.offX);
        buffer.method_10804(this.offY);
        buffer.method_10804(this.offZ);
        buffer.method_10804(this.viewOffX);
        buffer.method_10804(this.viewOffY);
        buffer.method_10804(this.viewOffZ);
        buffer.method_10804(this.size.method_10263());
        buffer.method_10804(this.size.method_10264());
        for (int y = 0; y < this.size.method_10264(); ++y) {
            for (int x = 0; x < this.size.method_10263(); ++x) {
                buffer.method_10814(this.pattern[y][x]);
            }
        }
        buffer.method_10804(this.targets.size());
        for (Map.Entry<Character, StateMatcher> entry : this.targets.entrySet()) {
            buffer.writeChar((int)entry.getKey().charValue());
            buffer.method_10812(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    @Override
    public class_2382 getSize() {
        return this.size;
    }

    public class_2680 method_8320(class_2338 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (x < 0 || y < 0 || z < 0 || x >= this.size.method_10263() || y >= this.size.method_10264() || z >= this.size.method_10260()) {
            return class_2246.field_10124.method_9564();
        }
        long ticks = this.level != null ? this.level.method_8510() : 0L;
        return this.stateMatchers[x][y][z].getDisplayedState(ticks);
    }
}

