/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.SimulateResultImpl;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class SparseMultiblock
extends AbstractMultiblock {
    public static final class_2960 TYPE = Modonomicon.loc("sparse");
    private final Map<class_2338, StateMatcher> stateMatchers;
    private final class_2382 size;

    public SparseMultiblock(Map<class_2338, StateMatcher> stateMatchers) {
        Preconditions.checkArgument((!stateMatchers.isEmpty() ? 1 : 0) != 0, (Object)"No data given to sparse multiblock!");
        this.stateMatchers = ImmutableMap.copyOf(stateMatchers);
        this.size = this.calculateSize();
    }

    public static SparseMultiblock fromJson(JsonObject json) {
        JsonObject jsonMapping = class_3518.method_15296((JsonObject)json, (String)"mapping");
        Map<Character, StateMatcher> mapping = SparseMultiblock.mappingFromJson(jsonMapping);
        JsonObject jsonPattern = class_3518.method_15296((JsonObject)json, (String)"pattern");
        Object2ObjectOpenHashMap stateMatchers = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : jsonPattern.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Pattern key needs to be only 1 character");
            }
            StateMatcher matcher = mapping.get(Character.valueOf(((String)entry.getKey()).charAt(0)));
            JsonArray jsonPositions = class_3518.method_15252((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            for (JsonElement jsonPosition : jsonPositions) {
                JsonArray jsonPos = class_3518.method_15252((JsonElement)jsonPosition, (String)((String)entry.getKey()));
                if (jsonPos.size() != 3) {
                    throw new JsonSyntaxException("Each matcher position needs to be an array of 3 integers");
                }
                stateMatchers.put(new class_2338(jsonPos.get(0).getAsInt(), jsonPos.get(1).getAsInt(), jsonPos.get(2).getAsInt()), matcher);
            }
        }
        SparseMultiblock multiblock = new SparseMultiblock((Map<class_2338, StateMatcher>)stateMatchers);
        return SparseMultiblock.additionalPropertiesFromJson(multiblock, json);
    }

    public static SparseMultiblock fromNetwork(class_2540 buffer) {
        boolean symmetrical = buffer.readBoolean();
        int offX = buffer.method_10816();
        int offY = buffer.method_10816();
        int offZ = buffer.method_10816();
        int viewOffX = buffer.method_10816();
        int viewOffY = buffer.method_10816();
        int viewOffZ = buffer.method_10816();
        int size = buffer.method_10816();
        Object2ObjectOpenHashMap stateMatchers = new Object2ObjectOpenHashMap();
        for (int i = 0; i < size; ++i) {
            class_2338 pos = buffer.method_10811();
            class_2960 type = buffer.method_10810();
            StateMatcher matcher = LoaderRegistry.getStateMatcherNetworkLoader(type).fromNetwork(buffer);
            stateMatchers.put((Object)pos, (Object)matcher);
        }
        SparseMultiblock multiblock = new SparseMultiblock((Map<class_2338, StateMatcher>)stateMatchers);
        multiblock.setSymmetrical(symmetrical);
        multiblock.setOffset(offX, offY, offZ);
        multiblock.setViewOffset(viewOffX, viewOffY, viewOffZ);
        return multiblock;
    }

    private class_2382 calculateSize() {
        int minX = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10263).min().getAsInt();
        int maxX = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10263).max().getAsInt();
        int minY = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10264).min().getAsInt();
        int maxY = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10264).max().getAsInt();
        int minZ = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10260).min().getAsInt();
        int maxZ = this.stateMatchers.keySet().stream().mapToInt(class_2382::method_10260).max().getAsInt();
        return new class_2382(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
    }

    @Override
    public class_2382 getSize() {
        return this.size;
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public Pair<class_2338, Collection<Multiblock.SimulateResult>> simulate(class_1937 world, class_2338 anchor, class_2470 rotation, boolean forView, boolean disableOffset) {
        class_2338 disp;
        class_2338 class_23382 = disp = forView ? new class_2338(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).method_10070(rotation) : new class_2338(-this.offX, -this.offY, -this.offZ).method_10070(rotation);
        if (disableOffset) {
            disp = class_2338.field_10980;
        }
        class_2338 origin = anchor.method_10081((class_2382)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (Map.Entry<class_2338, StateMatcher> e : this.stateMatchers.entrySet()) {
            class_2338 currDisp = e.getKey().method_10070(rotation);
            class_2338 actionPos = origin.method_10081((class_2382)currDisp);
            ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(class_1937 world, class_2338 start, int x, int y, int z, class_2470 rotation) {
        this.setLevel(world);
        class_2338 checkPos = start.method_10081((class_2382)new class_2338(x, y, z).method_10070(rotation));
        class_2680 state = world.method_8320(checkPos).method_26186(AbstractMultiblock.fixHorizontal(rotation));
        StateMatcher matcher = this.stateMatchers.getOrDefault(new class_2338(x, y, z), Matchers.ANY);
        return matcher.getStatePredicate().test((class_1922)world, checkPos, state);
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.symmetrical);
        buffer.method_10804(this.offX);
        buffer.method_10804(this.offY);
        buffer.method_10804(this.offZ);
        buffer.method_10804(this.viewOffX);
        buffer.method_10804(this.viewOffY);
        buffer.method_10804(this.viewOffZ);
        buffer.method_10804(this.stateMatchers.size());
        for (Map.Entry<class_2338, StateMatcher> entry : this.stateMatchers.entrySet()) {
            buffer.method_10807(entry.getKey());
            buffer.method_10812(entry.getValue().getType());
            entry.getValue().toNetwork(buffer);
        }
    }

    public class_2680 method_8320(class_2338 pos) {
        long ticks = this.level != null ? this.level.method_8510() : 0L;
        return this.stateMatchers.getOrDefault(pos, Matchers.AIR).getDisplayedState(ticks);
    }
}

