/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class TagMatcher
implements StateMatcher {
    public static final class_2960 TYPE = Modonomicon.loc("tag");
    private final class_2680 displayState;
    private final java.util.function.Supplier<class_6862<class_2248>> tag;
    private final java.util.function.Supplier<Map<String, String>> props;
    private final TriPredicate<class_1922, class_2338, class_2680> predicate;

    protected TagMatcher(java.util.function.Supplier<class_6862<class_2248>> tag, java.util.function.Supplier<Map<String, String>> props) {
        this(null, tag, props);
    }

    protected TagMatcher(class_2680 displayState, java.util.function.Supplier<class_6862<class_2248>> tag, java.util.function.Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.tag = tag;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.method_26164(this.tag.get()) && TagMatcher.checkProps(blockState, this.props);
    }

    public static TagMatcher fromJson(JsonObject json) {
        Object tagString;
        class_2680 displayState = null;
        if (json.has("display")) {
            try {
                displayState = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(class_3518.method_15265((JsonObject)json, (String)"display")), (boolean)false).comp_622();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for TagStateMatcher.", e);
            }
        }
        if (!((String)(tagString = class_3518.method_15265((JsonObject)json, (String)"tag"))).startsWith("#")) {
            tagString = "#" + (String)tagString;
        }
        String finalTagString = tagString;
        Supplier tagSupplier = Suppliers.memoize(() -> {
            try {
                class_2259.class_7212 parserResult = (class_2259.class_7212)class_2259.method_41960((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(finalTagString), (boolean)true).right().orElseThrow();
                return (class_6862)parserResult.comp_625().method_40248().left().orElseThrow();
            }
            catch (CommandSyntaxException e) {
                Modonomicon.LOG.error("Failed to parse Tag and BlockState properties from json member \"tag\" for TagMatcher: {0}. Will use \"modonomicon:bedrock\" as fallback, Exception: {1}", (Object)finalTagString, (Object)e);
                return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Modonomicon.loc("bedrock"));
            }
        });
        Supplier propsSupplier = Suppliers.memoize(() -> {
            try {
                class_2259.class_7212 parserResult = (class_2259.class_7212)class_2259.method_41960((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(finalTagString), (boolean)true).right().orElseThrow();
                return parserResult.comp_626();
            }
            catch (CommandSyntaxException e) {
                Modonomicon.LOG.error("Failed to parse Tag and BlockState properties from json member \"tag\" for TagMatcher: {0}. Will use empty property map as fallback, Exception: {1}", (Object)finalTagString, (Object)e);
                return Map.of();
            }
        });
        return new TagMatcher(displayState, (java.util.function.Supplier<class_6862<class_2248>>)tagSupplier, (java.util.function.Supplier<Map<String, String>>)propsSupplier);
    }

    public static TagMatcher fromNetwork(class_2540 buffer) {
        try {
            class_2680 displayState = null;
            if (buffer.readBoolean()) {
                displayState = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(buffer.method_19772()), (boolean)false).comp_622();
            }
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)buffer.method_10810());
            Map props = buffer.method_34067(class_2540::method_19772, class_2540::method_19772);
            return new TagMatcher(displayState, () -> tag, () -> props);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse TagMatcher from network.", e);
        }
    }

    public static boolean checkProps(class_2680 state, java.util.function.Supplier<Map<String, String>> props) {
        for (Map.Entry<String, String> entry : props.get().entrySet()) {
            class_2769 prop = state.method_26204().method_9595().method_11663(entry.getKey());
            if (prop == null) {
                return false;
            }
            Comparable value = prop.method_11900(entry.getValue()).orElse(null);
            if (value == null) {
                return false;
            }
            if (state.method_11654(prop).equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        if (this.displayState != null) {
            return this.displayState;
        }
        ImmutableList all = ImmutableList.copyOf((Iterable)class_7923.field_41175.method_40286(this.tag.get()));
        if (all.isEmpty()) {
            return class_2246.field_9987.method_9564();
        }
        int idx = (int)(ticks / 20L % (long)all.size());
        return ((class_2248)((class_6880)all.get(idx)).comp_349()).method_9564();
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.method_10814(class_2259.method_9685((class_2680)this.displayState));
        }
        buffer.method_10812(this.tag.get().comp_327());
        buffer.method_34063(this.props.get(), class_2540::method_10814, class_2540::method_10814);
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.props, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagMatcher that = (TagMatcher)o;
        return this.tag.equals(that.tag) && this.props.equals(that.props) && this.displayState.equals(that.displayState);
    }
}

