/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ClickReadAllButtonMessage
implements Message {
    public static final class_2960 ID = new class_2960("modonomicon", "click_read_all_button");
    public class_2960 bookId;
    public boolean readAll;

    public ClickReadAllButtonMessage(class_2960 bookId, boolean readAll) {
        this.bookId = bookId;
        this.readAll = readAll;
    }

    public ClickReadAllButtonMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10812(this.bookId);
        buf.writeBoolean(this.readAll);
    }

    @Override
    public void decode(class_2540 buf) {
        this.bookId = buf.method_10810();
        this.readAll = buf.readBoolean();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        Book book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            boolean anyRead = false;
            for (BookEntry entry : book.getEntries().values()) {
                if (!this.readAll && !BookUnlockStateManager.get().isUnlockedFor((class_1657)player, entry) || !BookUnlockStateManager.get().readFor(player, entry)) continue;
                anyRead = true;
            }
            if (anyRead) {
                BookUnlockStateManager.get().updateAndSyncFor(player);
            }
        }
    }
}

