/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.networking.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SyncBookDataMessage
implements Message {
    public static final class_2960 ID = new class_2960("modonomicon", "sync_book_data");
    public ConcurrentMap<class_2960, Book> books = new ConcurrentHashMap<class_2960, Book>();

    public SyncBookDataMessage(ConcurrentMap<class_2960, Book> books) {
        this.books = books;
    }

    public SyncBookDataMessage(class_2540 buf) {
        this.decode(buf);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10804(this.books.size());
        for (Book book : this.books.values()) {
            buf.method_10812(book.getId());
            book.toNetwork(buf);
            buf.method_10804(book.getCategories().size());
            for (BookCategory category : book.getCategories().values()) {
                buf.method_10812(category.getId());
                category.toNetwork(buf);
                buf.method_10804(category.getEntries().size());
                for (BookEntry entry : category.getEntries().values()) {
                    buf.method_10812(entry.getType());
                    entry.toNetwork(buf);
                }
            }
            buf.method_10804(book.getCommands().size());
            for (BookCommand command : book.getCommands().values()) {
                buf.method_10812(command.getId());
                command.toNetwork(buf);
            }
        }
    }

    @Override
    public void decode(class_2540 buf) {
        int bookCount = buf.method_10816();
        for (int i = 0; i < bookCount; ++i) {
            class_2960 bookId = buf.method_10810();
            Book book = Book.fromNetwork(bookId, buf);
            this.books.put(bookId, book);
            int categoryCount = buf.method_10816();
            for (int j = 0; j < categoryCount; ++j) {
                class_2960 categoryId = buf.method_10810();
                BookCategory category = BookCategory.fromNetwork(categoryId, buf);
                book.addCategory(category);
                int entryCount = buf.method_10816();
                for (int k = 0; k < entryCount; ++k) {
                    class_2960 entryTypeId = buf.method_10810();
                    BookEntry entry = LoaderRegistry.getEntryNetworkLoader(entryTypeId).fromNetwork(buf);
                    category.addEntry(entry);
                }
            }
            int commandCount = buf.method_10816();
            for (int j = 0; j < commandCount; ++j) {
                class_2960 commandId = buf.method_10810();
                BookCommand command = BookCommand.fromNetwork(commandId, buf);
                book.addCommand(command);
            }
        }
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        BookDataManager.get().onDatapackSyncPacket(this);
    }
}

