/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.screen.IJupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigScreen
extends class_437
implements IJupiterScreen {
    private final class_437 parent;
    protected final AbstractConfigContainer configContainer;
    protected final List<TabButton> groupButtons = new ArrayList<TabButton>();
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;
    private int configPerPage;
    private int textMaxLength;

    public AbstractConfigScreen(class_437 parent, AbstractConfigContainer configContainer) {
        super((class_2561)class_2561.method_43471((String)configContainer.getTitleNameKey()));
        this.parent = parent;
        this.configContainer = configContainer;
        this.currentGroup = configContainer.getConfigTabs().get(0);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), button -> this.method_25419()).method_46434(10, 5, 20, 15).method_46431());
        int x = 10;
        int y = 22;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.configContainer.getConfigTabs();
        for (int i = 0; i < configTabs.size(); ++i) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = (TabButton)this.method_37063((class_364)new TabButton(category, x, y, this.field_22793.method_1727(class_1074.method_4662((String)category.getTranslateKey(), (Object[])new Object[0])) + 10, 20, button -> {
                this.currentTab = this.configContainer.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.method_41843();
            }));
            tabButton.field_22763 = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.method_25368() + 2;
        }
        this.groupScrollBar.setMaxValue(Math.max(0, (x += 10) - this.field_22789));
        this.calculateMaxItems();
        this.textMaxLength = this.currentGroup.getConfigs().stream().map(IConfigEntry::getNameKey).map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).map(t -> this.field_22793.method_1727(t)).max(Comparator.naturalOrder()).orElse(0) + 30;
        this.configWidgets.clear();
        this.configWidgets.addAll(this.currentGroup.getConfigs().stream().map(WidgetBuilderManager::get).toList());
        this.configWidgets.forEach(b -> b.addElements(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, this.textMaxLength, 0, Math.max(10, this.field_22789 - this.textMaxLength - 30), 20));
        this.updateItemPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons) {
            button.updatePos(this.groupScrollBar.getValue());
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.field_22790 - 55) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, this.currentGroup.getConfigs().size() - this.configPerPage));
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        List<IConfigEntry<?>> entries = this.currentGroup.getConfigs();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.configWidgets.get(i).update(true, 60 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (super.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (mouseX >= 10.0 && mouseX <= (double)(this.field_22789 - 20) && mouseY >= 22.0 && mouseY <= 42.0) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (amount > 0.0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        if (mouseY > 42.0) {
            this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (amount > 0.0 ? -1 : 1) * 2);
            this.updateItemPos();
            return true;
        }
        return false;
    }

    public void method_25419() {
        this.configContainer.onConfigsChanged();
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_51439(this.field_22793, this.field_22785, 35, 10, -1, true);
        String currentText = this.getCurrentEditText();
        int textWidth = this.field_22793.method_1727(currentText);
        context.method_25303(this.field_22793, currentText, this.field_22789 - textWidth - 10, 10, -1);
        this.groupScrollBar.render(mouseX, mouseY, partialTicks, 10, 43, this.field_22789 - 20, 8, this.field_22789 + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) {
            this.updateTabPos();
        }
        this.itemScrollBar.render(mouseX, mouseY, partialTicks, this.field_22789 - 18, 55, 8, this.field_22790 - 70, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        if (mouseButton == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.method_25402(mouseX, mouseY, mouseButton);
        if (!b) {
            this.method_25395(null);
        }
        return b;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.groupScrollBar.setIsDragging(false);
            this.itemScrollBar.setIsDragging(false);
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    protected abstract String getCurrentEditText();

    public static class TabButton
    extends class_4185 {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, (class_2561)class_2561.method_43471((String)group.getTranslateKey()), button -> listener.accept((TabButton)button), field_40754);
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this.method_46421(this.baseX - offsetX);
        }
    }
}

