/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class BlockEntityAnimDataSyncPacket<D>
extends AbstractPacket {
    private final class_2338 blockPos;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public BlockEntityAnimDataSyncPacket(class_2338 pos, SerializableDataTicket<D> dataTicket, D data) {
        this.blockPos = pos;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10807(this.blockPos);
        buf.method_10814(this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> BlockEntityAnimDataSyncPacket<D> receive(class_2540 buf) {
        class_2338 pos = buf.method_10811();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buf.method_19772());
        return new BlockEntityAnimDataSyncPacket(pos, dataTicket, dataTicket.decode(buf));
    }

    @Override
    public void handle() {
        class_2586 blockEntity = ClientUtils.getLevel().method_8321(this.blockPos);
        if (blockEntity instanceof GeoBlockEntity) {
            GeoBlockEntity geoBlockEntity = (GeoBlockEntity)blockEntity;
            geoBlockEntity.setAnimData(this.dataTicket, this.data);
        }
    }
}

