/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzlesaccessapi.api.client.data.v2.BlockModelBuilder;
import fuzs.puzzlesaccessapi.api.client.data.v2.ItemModelBuilder;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class AbstractModelProvider
implements class_2405 {
    public static final String BLOCK_PATH = "block";
    public static final String ITEM_PATH = "item";
    private final String modId;
    private final class_7784.class_7489 blockStatePathProvider;
    private final class_7784.class_7489 modelPathProvider;

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, class_7784 packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "blockstates");
        this.modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
    }

    public abstract void addBlockModels(BlockModelBuilder var1);

    public abstract void addItemModels(ItemModelBuilder var1);

    protected boolean throwForMissingBlocks() {
        return true;
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashMap generators = Maps.newHashMap();
        Consumer<class_4917> blockStateOutput = generator -> {
            class_2248 block = generator.method_25743();
            class_4917 blockstategenerator = generators.put(block, generator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate block state definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = Sets.newHashSet();
        BiConsumer<class_2960, Supplier> modelOutput = (resourceLocation, supplier) -> {
            if (models.put(resourceLocation, supplier) != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        this.addBlockModels(new BlockModelBuilder(blockStateOutput, modelOutput, skippedAutoModels::add));
        this.addItemModels(new ItemModelBuilder(modelOutput));
        List<Object> missingBlocks = this.throwForMissingBlocks() ? class_7923.field_41175.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(this.modId) && !generators.containsKey(entry.getValue())).map(Map.Entry::getValue).toList() : Collections.emptyList();
        if (!missingBlocks.isEmpty()) {
            throw new IllegalStateException("Missing block state definitions for " + missingBlocks);
        }
        class_7923.field_41175.method_29722().forEach(entry -> {
            class_1792 item = (class_1792)class_1792.field_8003.get(entry.getValue());
            if (item != null) {
                if (!((class_5321)entry.getKey()).method_29177().method_12836().equals(this.modId) || skippedAutoModels.contains(item)) {
                    return;
                }
                class_2960 resourcelocation = class_4941.method_25840((class_1792)item);
                if (!models.containsKey(resourcelocation)) {
                    models.put(resourcelocation, new class_4940(class_4941.method_25842((class_2248)((class_2248)entry.getValue()))));
                }
            }
        });
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AbstractModelProvider.saveCollection(output, generators, block -> this.blockStatePathProvider.method_44107(block.method_40142().method_40237().method_29177()));
        completableFutureArray[1] = AbstractModelProvider.saveCollection(output, models, arg_0 -> ((class_7784.class_7489)this.modelPathProvider).method_44107(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    public final String method_10321() {
        return "Model Definitions";
    }

    private static <T> CompletableFuture<?> saveCollection(class_7403 output, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> pathExtractor) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)pathExtractor.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return class_2405.method_10320((class_7403)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public static class_2960 getModelLocation(class_2248 block) {
        return AbstractModelProvider.decorateBlockModelLocation(AbstractModelProvider.getLocation(block));
    }

    public static class_2960 decorateBlockModelLocation(class_2960 resourceLocation) {
        return resourceLocation.method_45138("block/");
    }

    public static class_2960 getLocation(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static String getName(class_2248 block) {
        return AbstractModelProvider.getLocation(block).method_12832();
    }

    public static class_2960 getModelLocation(class_1792 item) {
        return AbstractModelProvider.decorateItemModelLocation(AbstractModelProvider.getLocation(item));
    }

    public static class_2960 decorateItemModelLocation(class_2960 resourceLocation) {
        return resourceLocation.method_45138("item/");
    }

    public static class_2960 getLocation(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static String getName(class_1792 item) {
        return AbstractModelProvider.getLocation(item).method_12832();
    }

    public static class_2960 stripUntil(class_2960 resourceLocation, String s) {
        String path = resourceLocation.method_12832();
        if (path.contains(s)) {
            path = path.substring(path.lastIndexOf(s) + 1);
            return new class_2960(resourceLocation.method_12836(), path);
        }
        return resourceLocation;
    }

    public static class_4942.class_8073 overrides(class_4942 modelTemplate, ItemOverride.Factory ... factories) {
        return (resourceLocation, map) -> {
            JsonObject jsonObject = modelTemplate.method_48524(resourceLocation, map);
            JsonArray jsonArray = new JsonArray();
            for (ItemOverride.Factory factory : factories) {
                jsonArray.add(((ItemOverride)factory.apply(resourceLocation)).toJson());
            }
            jsonObject.add("overrides", (JsonElement)jsonArray);
            return jsonObject;
        };
    }

    public record ItemOverride(class_2960 model, Map<class_2960, Float> predicates) {
        public static ItemOverride of(class_2960 model, class_2960 p1, float f1) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1)));
        }

        public static ItemOverride of(class_2960 model, class_2960 p1, float f1, class_2960 p2, float f2) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1), p2, Float.valueOf(f2)));
        }

        public static ItemOverride of(class_2960 model, class_2960 p1, float f1, class_2960 p2, float f2, class_2960 p3, float f3) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1), p2, Float.valueOf(f2), p3, Float.valueOf(f3)));
        }

        JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            JsonObject predicates = new JsonObject();
            for (Map.Entry<class_2960, Float> entry : this.predicates.entrySet()) {
                predicates.addProperty(entry.getKey().toString(), (Number)entry.getValue());
            }
            jsonObject.add("predicate", (JsonElement)predicates);
            jsonObject.addProperty("model", this.model.toString());
            return jsonObject;
        }

        public static interface Factory
        extends Function<class_2960, ItemOverride> {
        }
    }
}

