/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.bom.ChanceMaterialCost;
import dev.emi.emi.bom.ChanceState;
import dev.emi.emi.bom.FlatMaterialCost;
import dev.emi.emi.bom.FoldState;
import dev.emi.emi.bom.MaterialNode;
import dev.emi.emi.bom.ProgressState;
import dev.emi.emi.bom.TreeCost;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.screen.RecipeScreen;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.RecipeTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_6880;

public class BoMScreen
extends class_437 {
    private static final int NODE_WIDTH = 30;
    private static final int NODE_HORIZONTAL_SPACING = 8;
    private static final int NODE_VERTICAL_SPACING = 20;
    private static final int COST_HORIZONTAL_SPACING = 8;
    private static final EmiBind LEFT_CLICK = new EmiBind("", new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(0), 0));
    private static StackBatcher batcher = new StackBatcher();
    private static int zoom = 0;
    private Bounds batches = new Bounds(-24, -50, 48, 26);
    private Bounds mode = new Bounds(-24, -50, 16, 16);
    private Bounds help = new Bounds(0, 0, 16, 16);
    private double offX;
    private double offY;
    private List<Node> nodes = Lists.newArrayList();
    private List<Cost> costs = Lists.newArrayList();
    private EmiPlayerInventory playerInv;
    private boolean hasRemainders = false;
    public class_465<?> old;
    private int nodeWidth = 0;
    private int nodeHeight = 0;
    private int lastMouseX;
    private int lastMouseY;
    private double scrollAcc = 0.0;

    public BoMScreen(class_465<?> old) {
        super((class_2561)EmiPort.translatable("screen.emi.recipe_tree"));
        this.old = old;
    }

    public void method_25426() {
        this.offY = BoM.tree != null ? (double)(this.field_22790 / -3) : 0.0;
        this.recalculateTree();
    }

    public void recalculateTree() {
        this.help = new Bounds(this.field_22789 - 18, this.field_22790 - 18, 16, 16);
        if (BoM.tree != null) {
            TreeVolume volume = this.addNewNodes(BoM.tree.goal, BoM.tree.batches, 1L, 0, ChanceState.DEFAULT);
            this.nodes = volume.nodes;
            int horizontalOffset = (volume.getMaxRight() + volume.getMinLeft()) / 2;
            for (Node node : volume.nodes) {
                node.x -= horizontalOffset;
            }
            if (!volume.nodes.isEmpty()) {
                Node node = volume.nodes.get(0);
                int width = this.field_22793.method_1727("x" + BoM.tree.batches);
                this.batches = new Bounds(node.x + node.width / 2 + 6, node.y - 10, width + 12, 22);
            }
            this.nodeWidth = volume.getMaxRight() - volume.getMinLeft();
            this.nodeHeight = this.getNodeHeight(BoM.tree.goal);
            this.playerInv = EmiPlayerInventory.of((class_1657)this.field_22787.field_1724);
            BoM.tree.calculateProgress(this.playerInv);
            Map<EmiIngredient, FlatMaterialCost> progressCosts = BoM.tree.cost.costs.values().stream().collect(Collectors.toMap(c -> c.ingredient, c -> c));
            Map<EmiIngredient, ChanceMaterialCost> chanceProgressCosts = BoM.tree.cost.chanceCosts.values().stream().collect(Collectors.toMap(c -> c.ingredient, c -> c));
            this.costs.clear();
            BoM.tree.calculateCost();
            List<ChanceMaterialCost> treeCosts = Stream.concat(BoM.tree.cost.costs.values().stream(), BoM.tree.cost.chanceCosts.values().stream()).sorted((a, b) -> Integer.compare(EmiStackList.getIndex(a.ingredient.getEmiStacks().get(0)), EmiStackList.getIndex(b.ingredient.getEmiStacks().get(0)))).toList();
            int cy = this.nodeHeight * 20 * 2;
            int costX = 0;
            for (FlatMaterialCost flatMaterialCost : treeCosts) {
                Cost cost = new Cost(flatMaterialCost, costX, cy, false);
                if (BoM.craftingMode) {
                    if (flatMaterialCost instanceof ChanceMaterialCost) {
                        ChanceMaterialCost cmc = (ChanceMaterialCost)flatMaterialCost;
                        if (!chanceProgressCosts.containsKey(flatMaterialCost.ingredient)) {
                            cost.alreadyDone = flatMaterialCost.getEffectiveAmount();
                        } else {
                            progress = chanceProgressCosts.get(flatMaterialCost.ingredient);
                            cost.alreadyDone = (long)Math.ceil((float)cmc.amount * cmc.chance - (float)((ChanceMaterialCost)progress).amount * ((ChanceMaterialCost)progress).chance);
                        }
                    } else if (!progressCosts.containsKey(flatMaterialCost.ingredient)) {
                        cost.alreadyDone = flatMaterialCost.amount;
                    } else {
                        progress = progressCosts.get(flatMaterialCost.ingredient);
                        cost.alreadyDone = flatMaterialCost.amount - progress.amount;
                    }
                }
                this.costs.add(cost);
                costX += 24 + EmiRenderHelper.getAmountOverflow(cost.getAmountText());
            }
            int costOffset = (costX - 8) / 2;
            for (Cost cost : this.costs) {
                cost.x -= costOffset;
            }
            int n = this.field_22793.method_27525((class_5348)EmiPort.translatable("emi.total_cost"));
            this.mode = new Bounds(n / 2 + 4, cy - 20, 16, 16);
            ArrayList remainders = Lists.newArrayList();
            List<ChanceMaterialCost> remainderCosts = Stream.concat(BoM.tree.cost.remainders.values().stream(), BoM.tree.cost.chanceRemainders.values().stream()).sorted((a, b) -> Integer.compare(EmiStackList.getIndex(a.ingredient.getEmiStacks().get(0)), EmiStackList.getIndex(b.ingredient.getEmiStacks().get(0)))).toList();
            cy += 40;
            int remainderX = 0;
            for (FlatMaterialCost flatMaterialCost : remainderCosts) {
                if (flatMaterialCost.getEffectiveAmount() <= 0L) continue;
                Cost cost = new Cost(flatMaterialCost, remainderX, cy, true);
                remainders.add(cost);
                remainderX += 24 + EmiRenderHelper.getAmountOverflow(cost.getAmountText());
            }
            costOffset = (remainderX - 8) / 2;
            for (Cost cost : remainders) {
                cost.x -= costOffset;
            }
            this.costs.addAll(remainders);
            this.hasRemainders = !remainders.isEmpty();
        } else {
            this.nodes = Lists.newArrayList();
        }
        batcher.repopulate();
    }

    public void method_25394(class_332 raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.method_25434(context.raw());
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        float scale = this.getScale();
        int scaledWidth = (int)((float)this.field_22789 / scale);
        int scaledHeight = (int)((float)this.field_22790 / scale);
        int contentWidth = this.nodeWidth * 30;
        int contentHeight = this.nodeHeight * 20 + 80;
        int xBound = scaledWidth / 2 + contentWidth - 100;
        int topBound = scaledHeight * 1 / -2 + 20;
        int bottomBound = contentHeight + scaledHeight / 2 - 20;
        this.offX = class_3532.method_15350((double)this.offX, (double)(-xBound), (double)xBound);
        this.offY = class_3532.method_15350((double)this.offY, (double)(-bottomBound), (double)(-topBound));
        int mx = (int)((double)((float)(mouseX - this.field_22789 / 2) / scale) - this.offX);
        int my = (int)((double)((float)(mouseY - this.field_22790 / 2) / scale) - this.offY);
        class_4587 view = RenderSystem.getModelViewStack();
        view.method_22903();
        view.method_46416((float)(this.field_22789 / 2), (float)(this.field_22790 / 2), 0.0f);
        view.method_22905(scale, scale, 1.0f);
        view.method_22904(this.offX, this.offY, 0.0);
        EmiPort.applyModelViewMatrix();
        if (BoM.tree != null) {
            batcher.begin(0, 0, 0);
            int cy = this.nodeHeight * 20 * 2;
            context.drawCenteredText((class_2561)EmiPort.translatable("emi.total_cost"), 0, cy - 16);
            if (this.hasRemainders) {
                context.drawCenteredText((class_2561)EmiPort.translatable("emi.leftovers"), 0, cy - 16 + 40);
            }
            for (Cost cost : this.costs) {
                cost.render(context);
            }
            for (Node node : this.nodes) {
                node.render(context, mx, my, delta);
            }
            int color = -1;
            if (this.batches.contains(mx, my)) {
                color = -8349185;
            }
            context.drawTextWithShadow((class_2561)EmiPort.literal("x" + BoM.tree.batches), this.batches.x() + 6, this.batches.y() + this.batches.height() / 2 - 4, color);
            if (this.mode.contains(mx, my)) {
                context.setColor(0.5f, 0.6f, 1.0f, 1.0f);
            }
            context.drawTexture(EmiRenderHelper.WIDGETS, this.mode.x(), this.mode.y(), BoM.craftingMode ? 16 : 0, 146, this.mode.width(), this.mode.height());
            context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            batcher.draw();
        } else {
            context.drawCenteredText((class_2561)EmiPort.translatable("emi.tree_welcome", EmiRenderHelper.getEmiText()), 0, -72);
            context.drawCenteredText((class_2561)EmiPort.translatable("emi.no_tree"), 0, -48);
            context.drawCenteredText((class_2561)EmiPort.translatable("emi.random_tree"), 0, -24);
            context.drawCenteredText((class_2561)EmiPort.translatable("emi.random_tree_input"), 0, 0);
        }
        view.method_22909();
        EmiPort.applyModelViewMatrix();
        if (this.help.contains(mouseX, mouseY)) {
            context.setColor(0.5f, 0.6f, 1.0f, 1.0f);
        }
        context.drawTexture(EmiRenderHelper.WIDGETS, this.help.x(), this.help.y(), 0, 200, this.help.width(), this.help.height());
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        Hover hover = this.getHoveredStack(mouseX, mouseY);
        if (hover != null) {
            hover.drawTooltip(this, context, mouseX, mouseY);
        } else if (BoM.tree != null && this.batches.contains(mx, my)) {
            ArrayList list = Lists.newArrayList();
            list.addAll(EmiTooltip.splitTranslate("tooltip.emi.bom.batch_size", BoM.tree.batches));
            list.add(EmiTooltipComponents.of((class_2561)EmiPort.translatable("tooltip.emi.bom.batch_size.ideal", LEFT_CLICK.getBindText())));
            EmiRenderHelper.drawTooltip(this, context, list, mouseX, mouseY);
        } else if (BoM.tree != null && this.mode.contains(mx, my)) {
            String key = BoM.craftingMode ? "tooltip.emi.bom.mode.craft" : "tooltip.emi.bom.mode.view";
            List<class_5684> list = EmiTooltip.splitTranslate(key, BoM.tree.batches);
            EmiRenderHelper.drawTooltip(this, context, list, mouseX, mouseY);
        } else if (this.help.contains(mouseX, mouseY)) {
            List<class_5684> list = EmiTooltip.splitTranslate("tooltip.emi.bom.help");
            EmiRenderHelper.drawTooltip(this, context, list, this.field_22789 - 18, this.field_22790 - 18, this.field_22789);
        }
    }

    public Hover getHoveredStack(int mx, int my) {
        float scale = this.getScale();
        mx = (int)((double)((float)(mx - this.field_22789 / 2) / scale) - this.offX);
        my = (int)((double)((float)(my - this.field_22790 / 2) / scale) - this.offY);
        for (Cost cost : this.costs) {
            if (mx < cost.x || mx >= cost.x + 16 || my < cost.y || my >= cost.y + 16) continue;
            return new Hover(cost.cost.ingredient);
        }
        for (Node node : this.nodes) {
            Hover hover = node.getHover(mx, my);
            if (hover == null) continue;
            return hover;
        }
        return null;
    }

    public int getNodeHeight(MaterialNode node) {
        if (node.recipe != null && node.state == FoldState.EXPANDED) {
            int i = 1;
            for (MaterialNode n : node.children) {
                i = Math.max(i, this.getNodeHeight(n));
            }
            if (node.recipe instanceof EmiResolutionRecipe) {
                return i;
            }
            return i + 1;
        }
        return 1;
    }

    public TreeVolume addNewNodes(MaterialNode node, long multiplier, long divisor, int depth, ChanceState chance) {
        multiplier = TreeCost.isCatalyst(node.ingredient) ? node.amount : node.amount * (long)((int)Math.ceil((float)multiplier / (float)divisor));
        if (node.recipe != null && node.children.size() > 0 && node.state == FoldState.EXPANDED) {
            ChanceState produced = chance.produce(node.produceChance);
            if (node.recipe instanceof EmiResolutionRecipe) {
                TreeVolume volume = this.addNewNodes(node.children.get(0), multiplier, node.divisor, depth, produced);
                volume.nodes.get((int)0).resolution = node;
                return volume;
            }
            TreeVolume left = null;
            for (int i = 0; i < node.children.size(); ++i) {
                ChanceState consumed = produced.consume(node.children.get((int)i).consumeChance);
                TreeVolume volume = this.addNewNodes(node.children.get(i), multiplier, node.divisor, depth + 1, consumed);
                if (left == null) {
                    left = volume;
                    continue;
                }
                left.addToRight(volume);
            }
            left.addHead(node, multiplier, depth * 20, chance);
            return left;
        }
        return new TreeVolume(node, multiplier, depth * 20, chance);
    }

    private static void drawLine(EmiDrawContext context, int x1, int y1, int x2, int y2) {
        if (x2 < x1) {
            BoMScreen.drawLine(context, x2, y1, x1, y2);
            return;
        }
        if (y2 < y1) {
            BoMScreen.drawLine(context, x1, y2, x2, y1);
            return;
        }
        context.fill(x1, y1, x2 - x1 + 1, y2 - y1 + 1, -1);
    }

    public float getScale() {
        zoom = class_3532.method_15340((int)zoom, (int)-6, (int)4);
        int scale = (int)this.field_22787.method_22683().method_4495();
        int desired = scale + zoom;
        if (desired < 1) {
            zoom -= desired - 1;
            desired = 1;
        }
        return (float)desired / (float)scale;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        Function<EmiBind, Boolean> function = bind -> bind.matchesKey(keyCode, scanCode);
        if (function.apply(EmiConfig.back).booleanValue()) {
            EmiHistory.pop();
            return true;
        }
        Hover hover = this.getHoveredStack(this.lastMouseX, this.lastMouseY);
        if (hover != null && hover.stack != null && !hover.stack.isEmpty() && function.apply(EmiConfig.favorite).booleanValue()) {
            EmiFavorites.addFavorite(hover.stack, hover.node == null ? null : hover.node.recipe);
        }
        if (EmiInput.isControlDown() && keyCode == 82) {
            List<EmiRecipe> recipes = EmiApi.getRecipeManager().getRecipes();
            if (recipes.size() > 0) {
                for (int i = 0; i < 100000; ++i) {
                    EmiRecipe recipe = recipes.get(EmiUtil.RANDOM.nextInt(recipes.size()));
                    if (!recipe.supportsRecipeTree()) continue;
                    BoM.setGoal(recipe);
                    this.method_25426();
                    return true;
                }
            }
        } else if (EmiInput.isControlDown() && keyCode == 67) {
            BoM.tree = null;
            this.method_25426();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean getAutoResolutions(Hover hover, BiConsumer<EmiIngredient, EmiRecipe> consumer) {
        EmiPlayerInventory inv = this.playerInv;
        if (inv != null) {
            List<EmiStack> stacks = hover.stack.getEmiStacks();
            if (stacks.size() > 1) {
                for (EmiStack stack : stacks) {
                    if (!inv.inventory.containsKey(stack)) continue;
                    consumer.accept(hover.stack, new EmiResolutionRecipe(hover.stack, stack));
                    return true;
                }
                for (EmiStack stack : stacks) {
                    for (Cost cost : this.costs) {
                        if (!cost.cost.ingredient.equals(stack)) continue;
                        consumer.accept(hover.stack, new EmiResolutionRecipe(hover.stack, stack));
                        return true;
                    }
                }
                consumer.accept(hover.stack, new EmiResolutionRecipe(hover.stack, stacks.get(0)));
                return true;
            }
            EmiRecipe recipe = EmiUtil.getRecipeResolution(hover.stack, inv);
            if (recipe != null) {
                consumer.accept(hover.stack, recipe);
                return true;
            }
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Function<EmiBind, Boolean> function;
        long ideal;
        Hover hover = this.getHoveredStack((int)mouseX, (int)mouseY);
        float scale = this.getScale();
        int mx = (int)((mouseX - (double)(this.field_22789 / 2)) / (double)scale - this.offX);
        int my = (int)((mouseY - (double)(this.field_22790 / 2)) / (double)scale - this.offY);
        if (hover != null) {
            if (button == 1 && hover.node != null && hover.node.recipe != null) {
                if (EmiInput.isShiftDown()) {
                    BoM.tree.addResolution(hover.node.ingredient, null);
                } else if (!(hover.node.recipe instanceof EmiResolutionRecipe)) {
                    hover.node.state = hover.node.state == FoldState.EXPANDED ? FoldState.COLLAPSED : FoldState.EXPANDED;
                }
                this.recalculateTree();
                return true;
            }
            if (hover.stack != null) {
                if (EmiInput.isShiftDown() && button == 0) {
                    if (this.getAutoResolutions(hover, BoM.tree::addResolution)) {
                        this.recalculateTree();
                    }
                    return true;
                }
                if (button == 0) {
                    EmiApi.displayRecipes(hover.stack);
                    RecipeScreen.resolve = hover.stack;
                    class_310 client = class_310.method_1551();
                    client.field_1755.method_25423(client, client.field_1755.field_22789, client.field_1755.field_22790);
                    if (hover.node != null && hover.node.recipe != null) {
                        EmiApi.focusRecipe(hover.node.recipe);
                    }
                    return true;
                }
            }
        } else if (this.mode.contains(mx, my)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            BoM.craftingMode = !BoM.craftingMode;
            this.recalculateTree();
        } else if (this.batches.contains(mx, my) && BoM.tree != null && (ideal = BoM.tree.cost.getIdealBatch(BoM.tree.goal, 1L, 1L)) != BoM.tree.batches) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            BoM.tree.batches = ideal;
            this.recalculateTree();
        }
        if ((function = bind -> bind.matchesMouse(button)).apply(EmiConfig.back).booleanValue()) {
            EmiHistory.pop();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scrollAcc += amount;
        amount = (int)this.scrollAcc;
        this.scrollAcc %= 1.0;
        float scale = this.getScale();
        int mx = (int)((mouseX - (double)(this.field_22789 / 2)) / (double)scale - this.offX);
        int my = (int)((mouseY - (double)(this.field_22790 / 2)) / (double)scale - this.offY);
        if (BoM.tree != null && this.batches.contains(mx, my)) {
            if (EmiInput.isShiftDown()) {
                amount *= 16.0;
            }
            BoM.tree.batches = BoM.tree.batches == 1L && amount > 1.0 ? (long)((int)amount) : (BoM.tree.batches += (long)((int)amount));
            BoM.tree.batches = Math.max(1L, BoM.tree.batches);
            this.recalculateTree();
            return true;
        }
        zoom += (int)amount;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 || button == 2) {
            float scale = this.getScale();
            this.offX += deltaX / (double)scale;
            this.offY += deltaY / (double)scale;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.old);
    }

    private class TreeVolume {
        public List<Width> widths = Lists.newArrayList();
        public List<Node> nodes = Lists.newArrayList();

        public TreeVolume(MaterialNode node, long amount, int y, ChanceState chance) {
            Node head = new Node(node, amount, 0, y, chance);
            int l = head.width / 2;
            this.widths.add(new Width(-l, head.width - l));
            this.nodes.add(head);
        }

        public void addHead(MaterialNode node, long amount, int y, ChanceState chance) {
            int x = (this.getLeft(0) + this.getRight(0)) / 2;
            Node newNode = new Node(node, amount, x, y, chance);
            for (Node n : this.nodes) {
                if (n.parent == null) {
                    n.parent = newNode;
                }
                n.y += 20;
            }
            int l = newNode.width / 2;
            this.widths.add(0, new Width(x - l, x + newNode.width - l));
            this.nodes.add(0, newNode);
        }

        public int getDepth() {
            return this.widths.size();
        }

        public int getMinLeft() {
            int m = this.getLeft(0);
            for (int i = 1; i < this.getDepth(); ++i) {
                m = Math.min(m, this.getLeft(i));
            }
            return m;
        }

        public int getMaxRight() {
            int m = this.getRight(0);
            for (int i = 1; i < this.getDepth(); ++i) {
                m = Math.max(m, this.getRight(i));
            }
            return m;
        }

        public int getLeft(int depth) {
            return this.widths.get((int)depth).left;
        }

        public int getRight(int depth) {
            return this.widths.get((int)depth).right;
        }

        public void addToRight(TreeVolume other) {
            int i;
            int rOff = this.getRight(0) - other.getLeft(0) + 8;
            for (i = 1; i < this.getDepth() && i < other.getDepth(); ++i) {
                rOff = Math.max(rOff, this.getRight(i) - other.getLeft(i) + 8);
            }
            for (i = 0; i < other.getDepth(); ++i) {
                if (i < this.getDepth()) {
                    this.widths.get((int)i).right = other.getRight(i) + rOff;
                    continue;
                }
                this.widths.add(new Width(other.getLeft(i) + rOff, other.getRight(i) + rOff));
            }
            for (Node node : other.nodes) {
                node.x += rOff;
                this.nodes.add(node);
            }
        }

        private static class Width {
            private int left;
            private int right;

            public Width(int left, int right) {
                this.left = left;
                this.right = right;
            }
        }
    }

    private class Node {
        public Node parent = null;
        public MaterialNode resolution = null;
        public MaterialNode node;
        public int width;
        public int x;
        public int y;
        public int midOffset;
        public long amount;
        public ChanceState chance;

        public Node(MaterialNode node, long amount, int x, int y, ChanceState chance) {
            this.node = node;
            this.width = node.recipe != null ? 42 : 16;
            this.amount = amount;
            this.x = x;
            this.y = y;
            this.chance = chance;
            int tw = EmiRenderHelper.getAmountOverflow(this.getAmountText());
            this.width += tw;
            this.midOffset = tw / -2;
        }

        public void render(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            if (this.parent != null) {
                context.push();
                this.setColor(context, this.parent.node, this.node.consumeChance != 1.0f || this.resolution != null && this.resolution.consumeChance != 1.0f, false);
                int nx = this.x;
                int ny = this.y;
                int px = this.parent.x;
                int py = this.parent.y;
                int off = 19;
                if (this.resolution != null) {
                    context.drawTexture(EmiRenderHelper.WIDGETS, this.x - 3, this.y - 19, 9, 192, 7, 7);
                    BoMScreen.drawLine(context, nx, this.y - 12, nx, ny - 11);
                    BoMScreen.drawLine(context, nx, py + off, nx, this.y - 19);
                } else {
                    BoMScreen.drawLine(context, nx, ny - 11, nx, py + off);
                }
                this.setColor(context, this.parent.node, false, false);
                BoMScreen.drawLine(context, px, py + off, nx, py + off);
                context.pop();
            }
            int xo = 0;
            if (this.node.recipe != null) {
                EmiRenderable emiRenderable;
                int lx = this.x - this.width / 2;
                int ly = this.y - 11;
                int hx = this.x + this.width / 2;
                int hy = this.y + 10;
                context.push();
                this.setColor(context, this.node, this.node.produceChance != 1.0f, false);
                if (this.node.state != FoldState.EXPANDED) {
                    BoMScreen.drawLine(context, this.x, hy + 1, this.x, hy + 3);
                } else {
                    BoMScreen.drawLine(context, this.x, hy + 1, this.x, hy + 8);
                }
                boolean hovered = mouseX >= lx && mouseY >= ly && mouseX <= hx && mouseY <= hy;
                this.setColor(context, this.node, this.node.produceChance != 1.0f, hovered);
                BoMScreen.drawLine(context, lx, ly, lx, hy);
                BoMScreen.drawLine(context, hx, ly, hx, hy);
                BoMScreen.drawLine(context, lx, ly, hx, ly);
                BoMScreen.drawLine(context, lx, hy, hx, hy);
                EmiRecipeCategory cat = this.node.recipe.getCategory();
                if (StackBatcher.isEnabled() && (emiRenderable = EmiRecipeCategoryProperties.getSimplifiedIcon(cat)) instanceof StackBatcher.Batchable) {
                    StackBatcher.Batchable b = (StackBatcher.Batchable)((Object)emiRenderable);
                    batcher.render(b, context.raw(), this.x - 18 + this.midOffset, this.y - 8, delta);
                } else {
                    cat.renderSimplified(context.raw(), this.x - 18 + this.midOffset, this.y - 8, delta);
                }
                xo = 11;
                context.pop();
            }
            context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            batcher.render(this.node.ingredient, context.raw(), this.x + xo - 8 + this.midOffset, this.y - 8, 0.0f);
            EmiRenderHelper.renderAmount(context, this.x + xo - 8 + this.midOffset, this.y - 8, this.getAmountText());
        }

        public void setColor(EmiDrawContext context, MaterialNode node, boolean chanced, boolean hovered) {
            context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (chanced) {
                context.setColor(0.8f, 0.6f, 0.1f, 1.0f);
            }
            if (BoM.craftingMode) {
                if (node.progress == ProgressState.COMPLETED) {
                    context.setColor(0.1f, 0.8f, 0.5f, 1.0f);
                } else if (node.progress == ProgressState.PARTIAL) {
                    context.setColor(0.8f, 0.2f, 0.9f, 1.0f);
                }
            }
            if (hovered) {
                context.setColor(0.5f, 0.6f, 1.0f, 1.0f);
            }
        }

        public class_2561 getAmountText() {
            if (this.chance.chanced()) {
                long a = Math.round((float)this.amount * this.chance.chance());
                a = Math.max(a, this.node.amount);
                return EmiPort.append(EmiPort.literal("\u2248"), EmiRenderHelper.getAmountText(this.node.ingredient, a)).method_27692(class_124.field_1065);
            }
            return EmiRenderHelper.getAmountText(this.node.ingredient, this.amount);
        }

        public Hover getHover(int mouseX, int mouseY) {
            if (this.resolution != null && mouseX >= this.x - 4 && mouseX < this.x + 4 && mouseY >= this.y - 19 && mouseY < this.y - 11) {
                return new Hover(this.resolution.ingredient, this.resolution, null);
            }
            int imx = mouseX;
            if (this.node.recipe != null) {
                if (mouseX >= this.x - 18 + this.midOffset && mouseX < this.x - 2 + this.midOffset && mouseY >= this.y - 8 && mouseY < this.y + 8) {
                    return new Hover(this.node.recipe.getCategory(), this.node);
                }
                imx -= 11;
            }
            if (imx >= this.x - 8 + this.midOffset && imx < this.x + 8 + this.midOffset && mouseY >= this.y - 8 && mouseY < this.y + 8) {
                return new Hover(this.node.ingredient, this.node, this.resolution);
            }
            int lx = this.x - this.width / 2;
            int ly = this.y - 11;
            int hx = this.x + this.width / 2;
            int hy = this.y + 10;
            if (mouseX >= lx && mouseY >= ly && mouseX <= hx && mouseY <= hy) {
                return new Hover(this.node);
            }
            return null;
        }
    }

    private class Cost {
        public FlatMaterialCost cost;
        public int x;
        public int y;
        public long alreadyDone = 0L;
        public boolean remainder;

        public Cost(FlatMaterialCost cost, int x, int y, boolean remainder) {
            this.cost = cost;
            this.x = x;
            this.y = y;
            this.remainder = remainder;
        }

        public void render(EmiDrawContext context) {
            batcher.render(this.cost.ingredient, context.raw(), this.x, this.y, 0.0f, -11);
            EmiRenderHelper.renderAmount(context, this.x, this.y, this.getAmountText());
        }

        public class_2561 getAmountText() {
            long amount;
            class_2561 totalText;
            long adjusted = this.cost.getEffectiveAmount();
            FlatMaterialCost flatMaterialCost = this.cost;
            if (flatMaterialCost instanceof ChanceMaterialCost) {
                ChanceMaterialCost cmc = (ChanceMaterialCost)flatMaterialCost;
                totalText = EmiPort.append(EmiPort.literal("\u2248"), EmiRenderHelper.getAmountText(this.cost.ingredient, adjusted)).method_27692(class_124.field_1065);
            } else {
                totalText = EmiRenderHelper.getAmountText(this.cost.ingredient, adjusted);
            }
            if (!this.remainder && BoM.craftingMode && (amount = this.alreadyDone) < adjusted) {
                class_5250 amountText = amount == 0L ? EmiPort.literal("0") : EmiRenderHelper.getAmountText(this.cost.ingredient, amount);
                class_5250 text = EmiPort.append(EmiPort.literal("", class_124.field_1061), (class_2561)amountText);
                text = EmiPort.append(text, (class_2561)EmiPort.literal("/"));
                text = EmiPort.append(text, totalText);
                return text;
            }
            return totalText;
        }
    }

    private class Hover {
        public EmiIngredient stack;
        public MaterialNode node;
        public MaterialNode resolve;
        public EmiRecipeCategory category;

        public Hover(EmiIngredient stack) {
            this.stack = stack;
        }

        public Hover(EmiIngredient stack, MaterialNode node, MaterialNode resolve) {
            this.stack = stack;
            this.node = node;
            this.resolve = resolve;
        }

        public Hover(EmiRecipeCategory category, MaterialNode node) {
            this.category = category;
            this.node = node;
        }

        public Hover(MaterialNode node) {
            this.node = node;
        }

        public boolean drawTooltip(class_437 screen, EmiDrawContext context, int mouseX, int mouseY) {
            if (this.stack != null) {
                ArrayList list = Lists.newArrayList();
                list.addAll(this.stack.getTooltip());
                if (EmiInput.isShiftDown()) {
                    BoMScreen.this.getAutoResolutions(this, (stack, recipe) -> {
                        if (this.node == null || recipe != this.node.recipe) {
                            list.add(new RecipeTooltipComponent((EmiRecipe)recipe, 1149829034));
                        } else {
                            list.add(new RecipeTooltipComponent((EmiRecipe)recipe));
                        }
                    });
                } else if (this.node != null && this.node.recipe != null) {
                    list.add(new RecipeTooltipComponent(this.node.recipe));
                }
                if (this.node != null) {
                    if (this.node.consumeChance != 1.0f) {
                        list.add(EmiTooltip.chance("consume", this.node.consumeChance));
                    } else if (this.resolve != null && this.resolve.consumeChance != 1.0f) {
                        list.add(EmiTooltip.chance("consume", this.resolve.consumeChance));
                    }
                    if (this.node.produceChance != 1.0f) {
                        list.add(EmiTooltip.chance("produce", this.node.produceChance));
                    }
                }
                EmiRenderHelper.drawTooltip(screen, context, list, mouseX, mouseY);
                return true;
            }
            if (this.category != null) {
                EmiRenderHelper.drawTooltip(screen, context, this.category.getTooltip(), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }
}

