/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.stack.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class TagEmiIngredientSerializer
implements EmiIngredientSerializer<TagEmiIngredient> {
    static final Pattern STACK_REGEX = Pattern.compile("^#([\\w_\\-.:]+):([\\w_\\-.]+):([\\w_\\-./]+)(\\{.*\\})?$");

    @Override
    public String getType() {
        return "tag";
    }

    @Override
    public EmiIngredient deserialize(JsonElement element) {
        if (class_3518.method_15286((JsonElement)element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                class_2960 registry = EmiPort.id(m.group(1));
                class_2960 id = EmiPort.id(m.group(2), m.group(3));
                return EmiIngredient.of(class_6862.method_40092((class_5321)class_5321.method_29180((class_2960)registry), (class_2960)id), 1L);
            }
        } else if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            class_2960 registry = EmiPort.id(json.get("registry").getAsString());
            class_2960 id = EmiPort.id(json.get("id").getAsString());
            long amount = class_3518.method_15280((JsonObject)json, (String)"amount", (long)1L);
            float chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
            EmiIngredient stack = EmiIngredient.of(class_6862.method_40092((class_5321)class_5321.method_29180((class_2960)registry), (class_2960)id), amount);
            if (chance != 1.0f) {
                stack.setChance(chance);
            }
            return stack;
        }
        return EmiStack.EMPTY;
    }

    @Override
    public JsonElement serialize(TagEmiIngredient stack) {
        if (stack.getAmount() == 1L && stack.getChance() == 1.0f) {
            String type = switch (stack.key.comp_326().method_29177().toString()) {
                case "minecraft:item" -> "item";
                case "minecraft:fluid" -> "fluid";
                default -> null;
            };
            return new JsonPrimitive("#" + type + ":" + stack.key.comp_327());
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "tag");
        json.addProperty("registry", stack.key.comp_326().method_29177().toString());
        json.addProperty("id", stack.key.comp_327().toString());
        if (stack.getAmount() != 1L) {
            json.addProperty("amount", (Number)stack.getAmount());
        }
        if (stack.getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(stack.getChance()));
        }
        return json;
    }
}

