/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;

public class FluidPart
extends class_630 {
    private final FluidTank leftTank = this.createFluidTank(1L);
    private final FluidTank rightTank = this.createFluidTank(1L);
    private class_4597 vertices;

    public FluidPart(class_630 parent) {
        super(parent.field_3663, parent.field_3661);
    }

    public void prepare(class_1799 stack, class_4597 vertices) {
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545("LeftTank")) {
                this.leftTank.readNbt(stack.method_7969().method_10562("LeftTank"));
            } else if (!this.leftTank.isResourceBlank()) {
                this.leftTank.variant = FluidVariant.blank();
                this.leftTank.amount = 0L;
            }
            if (stack.method_7969().method_10545("RightTank")) {
                this.rightTank.readNbt(stack.method_7969().method_10562("RightTank"));
            } else if (!this.rightTank.isResourceBlank()) {
                this.rightTank.variant = FluidVariant.blank();
                this.rightTank.amount = 0L;
            }
        }
        this.vertices = vertices;
    }

    public void method_22698(class_4587 matrices, class_4588 vertices, int light, int overlay) {
        if (this.vertices == null) {
            LogHelper.error("Rendering error! Trying to render FluidPart without passing vertices!", new Object[0]);
            return;
        }
        matrices.method_22903();
        this.method_22703(matrices);
        this.render(matrices, this.vertices, light);
        matrices.method_22909();
    }

    public void render(class_4587 matrices, class_4597 vertices, int light) {
        matrices.method_22903();
        matrices.method_22905(1.0f, 1.05f, 1.0f);
        RenderUtils.renderFluidInTank(this.leftTank, matrices, vertices, light, -0.66f, -0.55f, -0.235f);
        RenderUtils.renderFluidInTank(this.rightTank, matrices, vertices, light, 0.24f, -0.55f, -0.235f);
        matrices.method_22909();
    }

    public FluidTank createFluidTank(long tankCapacity) {
        return new FluidTank(tankCapacity){

            @Override
            public FluidTank readNbt(class_2487 nbt) {
                this.setCapacity(nbt.method_10545("capacity") ? nbt.method_10537("capacity") : 1000L);
                this.variant = FluidVariantImpl.fromNbt((class_2487)nbt.method_10562("variant"));
                this.amount = nbt.method_10537("amount");
                return this;
            }
        };
    }
}

