/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen.tooltip;

import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5632;

public class BackpackTooltipData
implements class_5632 {
    protected List<class_1799> storage = new ArrayList<class_1799>();
    protected List<class_1799> tools = new ArrayList<class_1799>();
    protected List<class_1799> crafting = new ArrayList<class_1799>();
    protected FluidTank leftTank = this.createFluidTank(Tiers.NETHERITE.getTankCapacity());
    protected FluidTank rightTank = this.createFluidTank(Tiers.NETHERITE.getTankCapacity());
    protected InventoryImproved inventory = new InventoryImproved(Tiers.NETHERITE.getStorageSlots());
    protected InventoryImproved toolSlotsInventory = new InventoryImproved(Tiers.NETHERITE.getToolSlots());
    protected InventoryImproved craftingInventory = new InventoryImproved(9);

    public BackpackTooltipData(class_1799 stack) {
        this.loadComponentData(stack.method_7969());
    }

    public void loadComponentData(class_2487 compound) {
        if (compound == null) {
            return;
        }
        this.loadFluidStacks(compound);
        this.storage = this.loadInventory(compound);
        this.crafting = this.loadCraftingInventory(compound);
        this.storage.addAll(this.crafting);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(compound);
    }

    public void loadFluidStacks(class_2487 compound) {
        if (compound.method_10545("LeftTank")) {
            this.leftTank.readNbt(compound.method_10562("LeftTank"));
        }
        if (compound.method_10545("RightTank")) {
            this.rightTank.readNbt(compound.method_10562("RightTank"));
        }
    }

    public List<class_1799> loadInventory(class_2487 compound) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (!compound.method_10545("Inventory")) {
            return Collections.emptyList();
        }
        this.inventory.readNbt(compound.method_10562("Inventory"));
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            if (this.inventory.method_5438(i).method_7960()) continue;
            list.add(this.inventory.method_5438(i));
        }
        return list;
    }

    public List<class_1799> mergeStacks(List<class_1799> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<class_1799> uniqueList = new ArrayList<class_1799>();
            for (class_1799 stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)uniqueList.get(i)))) continue;
                    int count = stack.method_7947() + ((class_1799)uniqueList.get(i)).method_7947();
                    uniqueList.set(i, stack.method_46651(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<class_1799> splittedList = new ArrayList<class_1799>();
            for (class_1799 itemStack : uniqueList) {
                if (itemStack.method_7947() > 999) {
                    int count = itemStack.method_7947();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.method_46651(999));
                    }
                    splittedList.add(itemStack.method_46651(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return Collections.emptyList();
    }

    public List<class_1799> loadTools(class_2487 compound) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (!compound.method_10545("ToolsInventory")) {
            return Collections.emptyList();
        }
        this.toolSlotsInventory.readNbt(compound.method_10562("ToolsInventory"));
        for (int i = 0; i < this.toolSlotsInventory.method_5439(); ++i) {
            if (this.toolSlotsInventory.method_5438(i).method_7960()) continue;
            list.add(this.toolSlotsInventory.method_5438(i));
        }
        return list;
    }

    public List<class_1799> loadCraftingInventory(class_2487 compound) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (!compound.method_10545("CraftingInventory")) {
            return Collections.emptyList();
        }
        this.craftingInventory.readNbt(compound.method_10562("CraftingInventory"));
        for (int i = 0; i < this.craftingInventory.method_5439(); ++i) {
            if (this.craftingInventory.method_5438(i).method_7960()) continue;
            list.add(this.craftingInventory.method_5438(i));
        }
        return list;
    }

    public FluidTank createFluidTank(long tankCapacity) {
        return new FluidTank(tankCapacity){

            protected void onFinalCommit() {
            }
        };
    }
}

