/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.darkwaters.entity.tasks;

import java.util.function.Consumer;
import mod.azure.darkwaters.entity.BaseWaterEntity;
import mod.azure.darkwaters.entity.CraekenEntity;
import mod.azure.darkwaters.entity.MiraidEntity;
import net.minecraft.class_3218;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public abstract class CustomDelayedBehaviour<E extends BaseWaterEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    public CustomDelayedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final CustomDelayedBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    protected final void start(class_3218 level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.method_18920(level, entity, gameTime);
        } else {
            super.method_18920(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
        if (entity instanceof MiraidEntity) {
            MiraidEntity miraid = (MiraidEntity)((Object)entity);
            miraid.triggerAnim("idle_controller", switch (miraid.method_6051().method_43048(3)) {
                case 0 -> "grab";
                case 1 -> "bite";
                case 2 -> "attack";
                default -> "grab";
            });
        } else if (entity instanceof CraekenEntity) {
            CraekenEntity craeken = (CraekenEntity)((Object)entity);
            craeken.triggerAnim("idle_controller", switch (craeken.method_6051().method_43048(2)) {
                case 0 -> "attack";
                default -> "grab";
            });
        } else {
            entity.triggerAnim("idle_controller", "attack");
        }
    }

    protected final void stop(class_3218 level, E entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        this.delayFinishedAt = 0L;
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.method_37908().method_8510();
    }

    protected final void tick(class_3218 level, E entity, long gameTime) {
        super.method_18924(level, entity, gameTime);
        ((BaseWaterEntity)((Object)entity)).setAttackingState(1);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

