/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.recipe;

import cc.abbie.emi_ores.compat.emi.EmiOresRecipeCategories;
import cc.abbie.emi_ores.compat.emi.recipe.AbstractPlacedFeatureEmiRecipe;
import cc.abbie.emi_ores.compat.emi.stack.BiomeEmiStack;
import cc.abbie.emi_ores.mixin.accessor.HeightRangePlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.NoiseProviderAccessor;
import cc.abbie.emi_ores.mixin.accessor.RarityFilterAccessor;
import cc.abbie.emi_ores.mixin.accessor.SimpleStateProviderAccessor;
import cc.abbie.emi_ores.mixin.accessor.WeightedStateProviderAccessor;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_4970;
import net.minecraft.class_5585;
import net.minecraft.class_5587;
import net.minecraft.class_5589;
import net.minecraft.class_6008;
import net.minecraft.class_6122;
import net.minecraft.class_6580;
import net.minecraft.class_6792;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;

public class GeodeGenEmiRecipe
extends AbstractPlacedFeatureEmiRecipe {
    private final class_6122 heightProvider;
    private final int rarityChance;
    private final EmiIngredient biomes;
    private final EmiIngredient alternateInner;
    private final EmiIngredient inner;
    private final EmiIngredient middle;
    private final EmiIngredient outer;
    private final EmiIngredient filling;
    private final EmiIngredient innerPlacements;
    private final class_2960 id;

    public GeodeGenEmiRecipe(class_6796 feature, class_2960 id) {
        this.id = id;
        class_6122 heightProvider = null;
        int rarityChance = -1;
        List<Object> biomes = List.of();
        for (class_6797 modifier : feature.comp_335()) {
            if (modifier instanceof class_6795) {
                class_6795 heightRangePlacement = (class_6795)modifier;
                heightProvider = ((HeightRangePlacementAccessor)heightRangePlacement).getHeight();
                continue;
            }
            if (modifier instanceof class_6799) {
                class_6799 rarityFilter = (class_6799)modifier;
                rarityChance = ((RarityFilterAccessor)rarityFilter).getChance();
                continue;
            }
            if (!(modifier instanceof class_6792)) continue;
            biomes = GeodeGenEmiRecipe.getBiomes(id, feature);
        }
        this.heightProvider = heightProvider;
        this.rarityChance = rarityChance;
        this.biomes = EmiIngredient.of(biomes.stream().map(BiomeEmiStack::of).collect(Collectors.toList()));
        class_5589 config = (class_5589)((class_2975)feature.comp_334().comp_349()).comp_333();
        class_5585 blockSettings = config.field_27316;
        class_5587 layerSettings = config.field_27317;
        this.alternateInner = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.field_27297).setChance((float)config.field_27320);
        this.filling = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.field_27295).setAmount((long)Math.ceil(layerSettings.field_27307));
        this.inner = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.field_27296).setAmount((long)Math.ceil(layerSettings.field_27308 - layerSettings.field_27307));
        this.middle = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.field_27298).setAmount((long)Math.ceil(layerSettings.field_27309 - layerSettings.field_27308));
        this.outer = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.field_27299).setAmount((long)Math.ceil(layerSettings.field_27310 - layerSettings.field_27309));
        this.innerPlacements = EmiIngredient.of(blockSettings.field_27300.stream().map(class_4970.class_4971::method_26204).map(EmiStack::of).collect(Collectors.toList())).setChance((float)config.field_27319);
    }

    private static EmiIngredient ingredientForStateProvider(class_4651 provider) {
        if (provider instanceof class_4656) {
            class_4656 simple = (class_4656)provider;
            return EmiStack.of((class_1935)((SimpleStateProviderAccessor)simple).getState().method_26204());
        }
        if (provider instanceof class_4657) {
            class_4657 weighted = (class_4657)provider;
            return EmiIngredient.of(((WeightedStateProviderAccessor)weighted).getWeightedList().method_34994().stream().map(class_6008.class_6010::method_34983).map(class_4970.class_4971::method_26204).map(EmiStack::of).toList());
        }
        if (provider instanceof class_6580) {
            class_6580 noise = (class_6580)provider;
            return EmiIngredient.of(((NoiseProviderAccessor)noise).getStates().stream().map(class_4970.class_4971::method_26204).distinct().map(EmiStack::of).toList());
        }
        return EmiStack.EMPTY;
    }

    public EmiRecipeCategory getCategory() {
        return EmiOresRecipeCategories.GEODE;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.biomes);
    }

    public List<EmiStack> getOutputs() {
        return Stream.of(this.innerPlacements, this.filling, this.alternateInner, this.inner, this.middle, this.outer).map(EmiIngredient::getEmiStacks).flatMap(Collection::stream).toList();
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        class_2561 veinFreq;
        widgets.addSlot(this.filling, 0, 18).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.innerPlacements, 46, 18).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.inner, 0, 36).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 36);
        widgets.addSlot(this.alternateInner, 46, 36).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.middle, 0, 54).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.outer, 0, 72).recipeContext((EmiRecipe)this);
        GeodeGenEmiRecipe.addDistributionGraph(widgets, 64, 0, this.heightProvider);
        if (!this.biomes.isEmpty()) {
            widgets.addSlot(this.biomes, 96, 18);
        }
        if ((veinFreq = GeodeGenEmiRecipe.getVeinFreqComponent(-1, -1, this.rarityChance)) != null) {
            widgets.addText(veinFreq, 160, 45, 0, false).horizontalAlign(TextWidget.Alignment.END).verticalAlign(TextWidget.Alignment.CENTER);
        }
    }
}

