/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import java.util.Objects;
import me.jellysquid.mods.lithium.common.hopper.ComparatorUpdatePattern;
import me.jellysquid.mods.lithium.common.hopper.LithiumDoubleInventory;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2621;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3954;
import org.jetbrains.annotations.Nullable;

public class HopperHelper {
    private static final class_265 CACHED_INPUT_VOLUME = class_2615.field_12026;
    private static final class_238[] CACHED_INPUT_VOLUME_BOXES = CACHED_INPUT_VOLUME.method_1090().toArray(new class_238[0]);

    public static class_238[] getHopperPickupVolumeBoxes(class_2615 hopper) {
        class_265 inputAreaShape = hopper.method_11262();
        if (inputAreaShape == CACHED_INPUT_VOLUME) {
            return CACHED_INPUT_VOLUME_BOXES;
        }
        return inputAreaShape.method_1090().toArray(new class_238[0]);
    }

    @Nullable
    public static class_1263 vanillaGetBlockInventory(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        return inventory;
    }

    public static boolean tryMoveSingleItem(class_1263 to, class_1799 stack, @Nullable class_2350 fromDirection) {
        class_1278 toSided;
        class_1278 class_12782 = toSided = to instanceof class_1278 ? (class_1278)to : null;
        if (toSided != null && fromDirection != null) {
            int[] slots = toSided.method_5494(fromDirection);
            for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slots[slotIndex], fromDirection)) continue;
                return true;
            }
        } else {
            int j = to.method_5439();
            for (int slot = 0; slot < j; ++slot) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slot, fromDirection)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryMoveSingleItem(class_1263 to, @Nullable class_1278 toSided, class_1799 transferStack, int targetSlot, @Nullable class_2350 fromDirection) {
        class_1799 toStack = to.method_5438(targetSlot);
        if (to.method_5437(targetSlot, transferStack) && (toSided == null || toSided.method_5492(targetSlot, transferStack, fromDirection))) {
            if (toStack.method_7960()) {
                class_1799 singleItem = transferStack.method_7971(1);
                to.method_5447(targetSlot, singleItem);
                return true;
            }
            if (toStack.method_31574(transferStack.method_7909())) {
                int toCount = toStack.method_7947();
                if (toStack.method_7914() > toCount && to.method_5444() > toCount && HopperHelper.areNbtEqual(toStack, transferStack)) {
                    transferStack.method_7934(1);
                    toStack.method_7933(1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean areNbtEqual(class_1799 stack1, class_1799 stack2) {
        return Objects.equals(stack1.method_7969(), stack2.method_7969());
    }

    private static int calculateReducedSignalStrength(float contentWeight, int inventorySize, int inventoryMaxCountPerStack, int numOccupiedSlots, int itemStackCount, int itemStackMaxCount) {
        int maxStackSize = Math.min(inventoryMaxCountPerStack, itemStackMaxCount);
        int newNumOccupiedSlots = numOccupiedSlots - (itemStackCount == 1 ? 1 : 0);
        float newContentWeight = contentWeight - 1.0f / (float)maxStackSize;
        return class_3532.method_15375((float)((newContentWeight /= (float)inventorySize) * 14.0f)) + (newNumOccupiedSlots > 0 ? 1 : 0);
    }

    public static ComparatorUpdatePattern determineComparatorUpdatePattern(class_1263 from, LithiumStackList fromStackList) {
        int newSignalStrength;
        int fromSlot;
        class_1799 itemStack;
        if (from instanceof class_2614 || !(from instanceof class_2621)) {
            return ComparatorUpdatePattern.NO_UPDATE;
        }
        float contentWeight = 0.0f;
        int numOccupiedSlots = 0;
        for (int j = 0; j < from.method_5439(); ++j) {
            class_1799 itemStack2 = from.method_5438(j);
            if (itemStack2.method_7960()) continue;
            int maxStackSize = Math.min(from.method_5444(), itemStack2.method_7914());
            contentWeight += (float)itemStack2.method_7947() / (float)maxStackSize;
            ++numOccupiedSlots;
        }
        float f = contentWeight;
        int originalSignalStrength = class_3532.method_15375((float)((f /= (float)from.method_5439()) * 14.0f)) + (numOccupiedSlots > 0 ? 1 : 0);
        ComparatorUpdatePattern updatePattern = ComparatorUpdatePattern.NO_UPDATE;
        int[] availableSlots = from instanceof class_1278 ? ((class_1278)from).method_5494(class_2350.field_11033) : null;
        class_1278 sidedInventory = from instanceof class_1278 ? (class_1278)from : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.method_5439();
        for (int i = 0; i < fromSize && ((itemStack = (class_1799)fromStackList.get(fromSlot = availableSlots != null ? availableSlots[i] : i)).method_7960() || sidedInventory != null && !sidedInventory.method_5493(fromSlot, itemStack, class_2350.field_11033) || (updatePattern = (newSignalStrength = HopperHelper.calculateReducedSignalStrength(contentWeight, from.method_5439(), from.method_5444(), numOccupiedSlots, itemStack.method_7947(), itemStack.method_7914())) != originalSignalStrength ? updatePattern.thenDecrementUpdateIncrementUpdate() : updatePattern.thenUpdate()).isChainable()); ++i) {
        }
        return updatePattern;
    }

    public static class_1263 replaceDoubleInventory(class_1263 blockInventory) {
        if (blockInventory instanceof class_1258) {
            class_1258 doubleInventory = (class_1258)blockInventory;
            if ((doubleInventory = LithiumDoubleInventory.getLithiumInventory(doubleInventory)) != null) {
                return doubleInventory;
            }
        }
        return blockInventory;
    }
}

