/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.block.CustomFarmBlock;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.mixin.FarmBlockAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FertilizedFarmlandBlock
extends class_2344
implements CustomFarmBlock {
    private final List<FarmlandTrait> traits;

    public FertilizedFarmlandBlock(FarmlandTrait ... traits) {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_11529).method_9632(0.6f).method_9640());
        this.traits = Lists.newArrayList((Object[])traits);
    }

    public boolean canSustainPlant(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction, class_2248 block) {
        return true;
    }

    public boolean isFertile(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)field_11009) > 0;
    }

    public float getDoubleGrowthChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getDoubleGrowthChance).sum();
    }

    public float getBonusCropChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getBonusCropChance).sum();
    }

    public float getRegressionChance() {
        return (float)FarmingForBlockheadsConfig.getActive().fertilizerRegressionChance;
    }

    private boolean isStable() {
        return this.traits.stream().anyMatch(FarmlandTrait::isStable);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!this.isStable()) {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int moisture = (Integer)state.method_11654((class_2769)field_11009);
        if (!FarmBlockAccessor.callIsNearWater((class_4538)level, pos) && !level.method_8520(pos.method_10084())) {
            if (moisture > 0) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)field_11009, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!FarmBlockAccessor.callShouldMaintainFarmland((class_1922)level, pos) && this.traits.stream().noneMatch(FarmlandTrait::isStable)) {
                FertilizedFarmlandBlock.method_10125(null, (class_2680)state, (class_1937)level, (class_2338)pos);
            }
        } else if (moisture < 7) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)field_11009, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public Collection<FarmlandTrait> getTraits() {
        return this.traits;
    }

    public void method_9568(class_1799 itemStack, @Nullable class_1922 blockGetter, List<class_2561> tooltip, class_1836 flag) {
        for (FarmlandTrait trait : this.traits) {
            class_5250 traitComponent = class_2561.method_43471((String)("tooltip.farmingforblockheads:trait_" + trait.getTraitName()));
            traitComponent.method_27692(trait.getTraitColor());
            tooltip.add((class_2561)traitComponent);
        }
    }

    public static interface FarmlandTrait {
        default public float getDoubleGrowthChance() {
            return 0.0f;
        }

        default public float getBonusCropChance() {
            return 0.0f;
        }

        default public boolean isStable() {
            return false;
        }

        public String getTraitName();

        public class_124 getTraitColor();
    }

    public static class FarmlandStableTrait
    implements FarmlandTrait {
        @Override
        public boolean isStable() {
            return true;
        }

        @Override
        public String getTraitName() {
            return "stable";
        }

        @Override
        public class_124 getTraitColor() {
            return class_124.field_1054;
        }
    }

    public static class FarmlandRichTrait
    implements FarmlandTrait {
        @Override
        public float getBonusCropChance() {
            return (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusCropChance;
        }

        @Override
        public String getTraitName() {
            return "rich";
        }

        @Override
        public class_124 getTraitColor() {
            return class_124.field_1060;
        }
    }

    public static class FarmlandHealthyTrait
    implements FarmlandTrait {
        @Override
        public float getDoubleGrowthChance() {
            return (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusGrowthChance;
        }

        @Override
        public String getTraitName() {
            return "healthy";
        }

        @Override
        public class_124 getTraitColor() {
            return class_124.field_1079;
        }
    }
}

