/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.compat.emi.EmiIntegration;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class MarketEmiRecipe
implements EmiRecipe {
    private final UUID uuid;
    private final class_2960 id;
    private final List<EmiStack> input;
    private final List<EmiStack> output;

    public MarketEmiRecipe(IMarketEntry marketEntry) {
        this.uuid = marketEntry.getEntryId();
        this.id = new class_2960("farmingforblockheads", "/market/%s".formatted(marketEntry.getEntryId().toString()));
        this.input = List.of(EmiStack.of((class_1799)marketEntry.getCostItem()));
        this.output = List.of(EmiStack.of((class_1799)marketEntry.getOutputItem()));
    }

    public EmiRecipeCategory getCategory() {
        return EmiIntegration.MARKET_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of(this.input));
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 86;
    }

    public int getDisplayHeight() {
        return 48;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiIntegration.BACKGROUND, 0, 0);
        widgets.addSlot((EmiIngredient)this.input.get(0), 15, 12);
        widgets.addSlot((EmiIngredient)this.output.get(0), 53, 12).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiIntegration.TRADE_ICON, 35, 13);
        class_2561 costText = this.getFormattedCostString();
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int stringWidth = fontRenderer.method_27525((class_5348)costText);
        widgets.addText(costText, (int)(42.0f - (float)stringWidth / 2.0f), 35, 0xFFFFFF, true);
    }

    private class_2561 getFormattedCostString() {
        class_5250 result = class_2561.method_43469((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{this.input.get(0).getAmount(), this.input.get(0).getItemStack().method_7954()});
        class_124 color = class_124.field_1060;
        if (this.input.get(0).getItemStack().method_7909() == class_1802.field_8477) {
            color = class_124.field_1075;
        }
        result.method_27692(color);
        return result;
    }
}

