/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class FertilizerItem
extends class_1792 {
    private final FertilizerType fertilizerType;

    public FertilizerItem(FertilizerType fertilizerType) {
        super(new class_1792.class_1793());
        this.fertilizerType = fertilizerType;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 heldItem = context.method_8041();
        if (this.tryApplyFertilizerAt(level, pos) || this.tryApplyFertilizerAt(level, pos.method_10074())) {
            if (!player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private boolean tryApplyFertilizerAt(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2680 newState = this.fertilizerType.applyFertilizer(state);
        if (newState != state) {
            world.method_8501(pos, newState);
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        class_5250 chatComponent = class_2561.method_43471((String)("tooltip.farmingforblockheads:fertilizer_" + this.fertilizerType.name().toLowerCase(Locale.ENGLISH)));
        chatComponent.method_27692(this.fertilizerType.getFarmlandTrait().getTraitColor());
        tooltip.add((class_2561)chatComponent);
    }

    public static enum FertilizerType {
        HEALTHY,
        RICH,
        STABLE;


        public boolean canFertilize(class_2680 state) {
            class_2248 sourceBlock = state.method_26204();
            return sourceBlock == class_2246.field_10362 || sourceBlock instanceof FertilizedFarmlandBlock;
        }

        public class_2680 applyFertilizer(class_2680 state) {
            class_2248 targetBlock;
            if (!this.canFertilize(state)) {
                return state;
            }
            int moisture = (Integer)state.method_11654((class_2769)class_2741.field_12510);
            ArrayList<FertilizedFarmlandBlock.FarmlandTrait> traits = new ArrayList<FertilizedFarmlandBlock.FarmlandTrait>();
            traits.add(this.getFarmlandTrait());
            class_2248 sourceBlock = state.method_26204();
            if (sourceBlock instanceof FertilizedFarmlandBlock) {
                traits.addAll(((FertilizedFarmlandBlock)sourceBlock).getTraits());
            }
            if ((targetBlock = FertilizerType.getBlockForTraits(traits)) == null) {
                return state;
            }
            class_2680 newState = targetBlock.method_9564();
            return (class_2680)newState.method_11657((class_2769)FertilizedFarmlandBlock.field_11009, (Comparable)Integer.valueOf(moisture));
        }

        private FertilizedFarmlandBlock.FarmlandTrait getFarmlandTrait() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEALTHY -> new FertilizedFarmlandBlock.FarmlandHealthyTrait();
                case RICH -> new FertilizedFarmlandBlock.FarmlandRichTrait();
                case STABLE -> new FertilizedFarmlandBlock.FarmlandStableTrait();
            };
        }

        @Nullable
        private static class_2248 getBlockForTraits(List<FertilizedFarmlandBlock.FarmlandTrait> traits) {
            boolean hasStableTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandStableTrait);
            boolean hasHealthyTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandHealthyTrait);
            boolean hasRichTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandRichTrait);
            if (hasStableTrait && !hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandStable;
            }
            if (!hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRich;
            }
            if (!hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthy;
            }
            if (hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRichStable;
            }
            if (hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthyStable;
            }
            return null;
        }
    }
}

