/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.api.IMarketOverrideData;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MarketRegistry {
    public static final MarketRegistry INSTANCE = new MarketRegistry();
    private final Map<class_2960, IMarketCategory> indexedCategories = new HashMap<class_2960, IMarketCategory>();
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entries = ArrayListMultimap.create();
    private final Map<UUID, IMarketEntry> entriesById = new HashMap<UUID, IMarketEntry>();
    private final Map<String, IMarketOverrideData> groupOverrides = new HashMap<String, IMarketOverrideData>();
    private final Map<String, IMarketOverrideData> entryOverrides = new HashMap<String, IMarketOverrideData>();
    private final Map<String, IMarketRegistryDefaultHandler> defaultHandlers = new HashMap<String, IMarketRegistryDefaultHandler>();

    public static void resetCategories() {
        MarketRegistry.INSTANCE.indexedCategories.clear();
    }

    public void registerCategory(IMarketCategory category) {
        if (this.indexedCategories.containsKey(category.getRegistryName())) {
            throw new RuntimeException("Attempted to register duplicate market category " + category.getRegistryName());
        }
        this.indexedCategories.put(category.getRegistryName(), category);
    }

    public void registerGroupOverride(String key, IMarketOverrideData override) {
        this.groupOverrides.put(key, override);
    }

    public void registerEntryOverride(String key, IMarketOverrideData override) {
        this.entryOverrides.put(key, override);
    }

    public void registerEntry(class_1799 outputItem, class_1799 costItem, @Nullable IMarketCategory category) {
        String registryName = Objects.toString(Balm.getRegistries().getKey(outputItem.method_7909()));
        IMarketOverrideData override = this.entryOverrides.get(registryName);
        if (category == null) {
            category = MarketRegistry.determineCategory(outputItem);
        }
        if (override == null || override.isEnabled()) {
            class_1799 payment = override != null && override.getPayment() != null ? override.getPayment() : costItem;
            class_1799 alteredOutputItem = ContainerUtils.copyStackWithSize((class_1799)outputItem, (int)(override != null ? override.getCount() : Math.min(outputItem.method_7947(), outputItem.method_7914())));
            MarketEntry entry = new MarketEntry(UUID.randomUUID(), alteredOutputItem, payment, category);
            this.entries.put((Object)category, (Object)entry);
            this.entriesById.put(entry.getEntryId(), entry);
        }
    }

    public void registerDefaults() {
        for (Map.Entry<String, IMarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            IMarketOverrideData override = this.groupOverrides.get(entry.getKey());
            IMarketRegistryDefaultHandler defaultHandler = entry.getValue();
            boolean enabled = defaultHandler.isEnabledByDefault();
            if (override != null) {
                enabled = override.isEnabled();
            }
            if (!enabled) continue;
            defaultHandler.register(override != null ? override.getPayment() : null, override != null ? Integer.valueOf(override.getCount()) : null);
        }
    }

    @Nullable
    public static IMarketEntry getEntryById(UUID entryId) {
        return MarketRegistry.INSTANCE.entriesById.get(entryId);
    }

    @Nullable
    public static IMarketEntry getEntryFor(class_1799 outputItem) {
        for (IMarketEntry entry : MarketRegistry.INSTANCE.entries.values()) {
            if (!class_1799.method_31577((class_1799)entry.getOutputItem(), (class_1799)outputItem) || outputItem.method_7947() != entry.getOutputItem().method_7947()) continue;
            return entry;
        }
        return null;
    }

    public static ArrayListMultimap<IMarketCategory, IMarketEntry> getGroupedEntries() {
        return MarketRegistry.INSTANCE.entries;
    }

    public static Collection<IMarketEntry> getEntries() {
        return MarketRegistry.INSTANCE.entries.values();
    }

    private static IMarketCategory determineCategory(class_1799 outputStack) {
        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategoryOther();
        class_2960 registryName = Balm.getRegistries().getKey(outputStack.method_7909());
        if (registryName != null) {
            if (registryName.method_12832().contains("sapling")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySaplings();
            } else if (registryName.method_12832().contains("seed")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySeeds();
            } else if (registryName.method_12832().contains("flower")) {
                category = FarmingForBlockheadsAPI.getMarketCategoryFlowers();
            }
        }
        return category;
    }

    public static void registerDefaultHandler(String defaultKey, IMarketRegistryDefaultHandler handler) {
        if (MarketRegistry.INSTANCE.defaultHandlers.containsKey(defaultKey)) {
            throw new RuntimeException("Attempted to register duplicate default handler " + defaultKey);
        }
        MarketRegistry.INSTANCE.defaultHandlers.put(defaultKey, handler);
    }

    public static Collection<IMarketCategory> getCategories() {
        return MarketRegistry.INSTANCE.indexedCategories.values();
    }

    @Nullable
    public static IMarketCategory getCategory(class_2960 id) {
        return MarketRegistry.INSTANCE.indexedCategories.get(id);
    }

    public void reset() {
        this.entryOverrides.clear();
        this.groupOverrides.clear();
        this.defaultHandlers.clear();
        this.indexedCategories.clear();
        this.entries.clear();
        this.entriesById.clear();
    }
}

