/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;

public class OverlayRenderer {
    public static final MutableObject<Theme> theme = new MutableObject((Object)IWailaConfig.get().getOverlay().getTheme());
    public static float ticks;
    public static boolean shown;
    public static float alpha;
    private static TooltipRenderer lingerTooltip;
    private static float disappearTicks;
    private static class_768 morphRect;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.method_1434()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || class_310.method_1551().field_1755 instanceof BaseOptionsScreen || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(TooltipRenderer tooltipRenderer) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return false;
        }
        if (!ClientProxy.shouldShowWithOverlay(mc, mc.field_1755)) {
            return false;
        }
        tooltipRenderer.recalculateRealRect();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof BaseOptionsScreen) {
            double y;
            BaseOptionsScreen optionsScreen = (BaseOptionsScreen)class_4372;
            if (!general.previewOverlay && !optionsScreen.forcePreviewOverlay()) {
                return false;
            }
            class_768 position = Objects.requireNonNull(tooltipRenderer.getRealRect());
            class_1041 window = mc.method_22683();
            double x = mc.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
            if (position.method_3318((int)x, (int)(y = mc.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507()))) {
                return false;
            }
        }
        if (mc.field_1690.field_1866 && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.method_18506() != null || mc.field_1690.field_1842) {
            return false;
        }
        return !mc.field_1705.method_1750().field_2158 || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(class_332 guiGraphics) {
        shown = false;
        boolean show = OverlayRenderer.shouldShow();
        TooltipRenderer tooltipRenderer = WailaTickHandler.instance().tooltipRenderer;
        float delta = class_310.method_1551().method_1534();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (tooltipRenderer != null) {
            lingerTooltip = tooltipRenderer;
        }
        if (tooltipRenderer == null && lingerTooltip != null) {
            if ((disappearTicks += delta) < overlay.getDisappearingDelay()) {
                tooltipRenderer = lingerTooltip;
                show = true;
            }
        } else {
            disappearTicks = 0.0f;
        }
        if (overlay.getAnimation() && lingerTooltip != null) {
            tooltipRenderer = lingerTooltip;
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (alpha < 0.1f || tooltipRenderer == null || !OverlayRenderer.shouldShowImmediately(tooltipRenderer)) {
            lingerTooltip = null;
            morphRect = null;
            WailaTickHandler.clearLastNarration();
            return;
        }
        ticks += delta;
        class_310.method_1551().method_16011().method_15396("Jade Overlay");
        OverlayRenderer.renderOverlay(tooltipRenderer, guiGraphics);
        class_310.method_1551().method_16011().method_15407();
    }

    public static void renderOverlay(TooltipRenderer tooltip, class_332 guiGraphics) {
        class_4587 matrixStack = guiGraphics.method_51448();
        matrixStack.method_22903();
        class_768 position = Objects.requireNonNull(tooltip.getRealRect());
        if (morphRect == null) {
            morphRect = new class_768(position.method_3321(), position.method_3322(), position.method_3319(), position.method_3320());
        } else {
            OverlayRenderer.chase(position, class_768::method_3321, arg_0 -> ((class_768)morphRect).method_35778(arg_0));
            OverlayRenderer.chase(position, class_768::method_3322, arg_0 -> ((class_768)morphRect).method_35781(arg_0));
            OverlayRenderer.chase(position, class_768::method_3319, arg_0 -> ((class_768)morphRect).method_35782(arg_0));
            OverlayRenderer.chase(position, class_768::method_3320, arg_0 -> ((class_768)morphRect).method_35783(arg_0));
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        colorSetting.alpha = overlay.getAlpha();
        Theme themeBefore = overlay.getTheme();
        theme.setValue((Object)themeBefore);
        colorSetting.theme = theme;
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.INSTANCE.beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(tooltip.getTooltip(), morphRect, guiGraphics, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.method_22909();
            return;
        }
        if (themeBefore != theme.getValue()) {
            tooltip.setPaddingFromTheme((Theme)theme.getValue());
        }
        float z = class_310.method_1551().field_1755 == null ? 1.0f : 100.0f;
        matrixStack.method_46416((float)morphRect.method_3321(), (float)morphRect.method_3322(), z);
        float scale = tooltip.getRealScale();
        if (scale != 1.0f) {
            matrixStack.method_22905(scale, scale, 1.0f);
        }
        boolean doDefault = true;
        colorSetting.alpha *= alpha;
        for (JadeRenderBackgroundCallback callback3 : WailaClientRegistration.INSTANCE.renderBackgroundCallback.callbacks()) {
            if (!callback3.onRender(tooltip, morphRect, guiGraphics, ObjectDataCenter.get(), colorSetting)) continue;
            doDefault = false;
            break;
        }
        RenderSystem.enableBlend();
        if (doDefault && colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(guiGraphics, 0, 0, class_3532.method_15386((float)((float)morphRect.method_3319() / scale)), class_3532.method_15386((float)((float)morphRect.method_3320() / scale)), colorSetting.alpha, overlay.getSquare(), tooltip);
        }
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(guiGraphics);
        WailaClientRegistration.INSTANCE.afterRenderCallback.call(callback -> callback.afterRender(tooltip.getTooltip(), morphRect, guiGraphics, ObjectDataCenter.get()));
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
        shown = true;
    }

    private static void chase(class_768 pos, ToIntFunction<class_768> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int value = getter.applyAsInt(morphRect);
            int target = getter.applyAsInt(pos);
            float diff = target - value;
            if (diff == 0.0f) {
                return;
            }
            float delta = class_310.method_1551().method_1534() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (class_3532.method_15379((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)value + diff));
        } else {
            setter.accept(getter.applyAsInt(pos));
        }
    }

    public static void drawTooltipBox(class_332 guiGraphics, int x, int y, int w, int h, float alpha, boolean square, TooltipRenderer tooltip) {
        Theme theme = (Theme)OverlayRenderer.theme.getValue();
        if (theme.backgroundTexture != null) {
            class_2960 texture = theme.backgroundTexture;
            int[] uv = theme.backgroundTextureUV;
            if (theme.backgroundTexture_withIcon != null && tooltip.hasIcon()) {
                texture = theme.backgroundTexture_withIcon;
                uv = theme.backgroundTextureUV_withIcon;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            OverlayRenderer.blitNineSliced(guiGraphics, texture, x, y, w, h, uv[3], uv[0], uv[1], uv[2], uv[4], uv[5], uv[6], uv[7]);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int bg;
            if (!square) {
                w -= 2;
                h -= 2;
            }
            if ((bg = theme.backgroundColor) != -1) {
                bg = IWailaConfig.IConfigOverlay.applyAlpha(bg, alpha);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + 1, y + 1, w - 2, h - 2, bg, bg);
                if (!square) {
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y - 1, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x - 1, y, 1.0f, h, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w, y, 1.0f, h, bg, bg);
                }
            }
            int[] borderColors = new int[4];
            for (int i = 0; i < 4; ++i) {
                borderColors[i] = IWailaConfig.IConfigOverlay.applyAlpha(theme.borderColor[i], alpha);
            }
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + 1, 1.0f, h - 2, borderColors[0], borderColors[3]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w - 1, y + 1, 1.0f, h - 2, borderColors[1], borderColors[2]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y, w, 1.0f, borderColors[0], borderColors[1]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h - 1, w, 1.0f, borderColors[3], borderColors[2]);
        }
    }

    public static void blitNineSliced(class_332 guiGraphics, class_2960 pAtlasLocation, int pTargetX, int pTargetY, int pTargetWidth, int pTargetHeight, int pCornerWidth, int pCornerHeight, int pEdgeWidth, int pEdgeHeight, int pSourceWidth, int pSourceHeight, int pSourceX, int pSourceY) {
        pCornerWidth = Math.min(pCornerWidth, pTargetWidth / 2);
        pEdgeWidth = Math.min(pEdgeWidth, pTargetWidth / 2);
        pCornerHeight = Math.min(pCornerHeight, pTargetHeight / 2);
        pEdgeHeight = Math.min(pEdgeHeight, pTargetHeight / 2);
        if (pTargetWidth == pSourceWidth && pTargetHeight == pSourceHeight) {
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pTargetWidth, pTargetHeight);
        } else if (pTargetHeight == pSourceHeight) {
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pCornerWidth, pTargetHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX + pCornerWidth, pTargetY, pTargetWidth - pEdgeWidth - pCornerWidth, pTargetHeight, pSourceX + pCornerWidth, pSourceY, pSourceWidth - pEdgeWidth - pCornerWidth, pSourceHeight);
            guiGraphics.method_25302(pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY, pSourceX + pSourceWidth - pEdgeWidth, pSourceY, pEdgeWidth, pTargetHeight);
        } else if (pTargetWidth == pSourceWidth) {
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pTargetWidth, pCornerHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX, pTargetY + pCornerHeight, pTargetWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX, pSourceY + pCornerHeight, pSourceWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY + pTargetHeight - pEdgeHeight, pSourceX, pSourceY + pSourceHeight - pEdgeHeight, pTargetWidth, pEdgeHeight);
        } else {
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY, pSourceX, pSourceY, pCornerWidth, pCornerHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX + pCornerWidth, pTargetY, pTargetWidth - pEdgeWidth - pCornerWidth, pCornerHeight, pSourceX + pCornerWidth, pSourceY, pSourceWidth - pEdgeWidth - pCornerWidth, pCornerHeight);
            guiGraphics.method_25302(pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY, pSourceX + pSourceWidth - pEdgeWidth, pSourceY, pEdgeWidth, pCornerHeight);
            guiGraphics.method_25302(pAtlasLocation, pTargetX, pTargetY + pTargetHeight - pEdgeHeight, pSourceX, pSourceY + pSourceHeight - pEdgeHeight, pCornerWidth, pEdgeHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX + pCornerWidth, pTargetY + pTargetHeight - pEdgeHeight, pTargetWidth - pEdgeWidth - pCornerWidth, pEdgeHeight, pSourceX + pCornerWidth, pSourceY + pSourceHeight - pEdgeHeight, pSourceWidth - pEdgeWidth - pCornerWidth, pEdgeHeight);
            guiGraphics.method_25302(pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY + pTargetHeight - pEdgeHeight, pSourceX + pSourceWidth - pEdgeWidth, pSourceY + pSourceHeight - pEdgeHeight, pEdgeWidth, pEdgeHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX, pTargetY + pCornerHeight, pCornerWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX, pSourceY + pCornerHeight, pCornerWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX + pCornerWidth, pTargetY + pCornerHeight, pTargetWidth - pEdgeWidth - pCornerWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX + pCornerWidth, pSourceY + pCornerHeight, pSourceWidth - pEdgeWidth - pCornerWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
            guiGraphics.method_48585(pAtlasLocation, pTargetX + pTargetWidth - pEdgeWidth, pTargetY + pCornerHeight, pEdgeWidth, pTargetHeight - pEdgeHeight - pCornerHeight, pSourceX + pSourceWidth - pEdgeWidth, pSourceY + pCornerHeight, pEdgeWidth, pSourceHeight - pEdgeHeight - pCornerHeight);
        }
    }
}

