/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.inventory.sorting;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.roundaround.inventorymanagement.inventory.sorting.ConditionalComparator;
import me.roundaround.inventorymanagement.inventory.sorting.SerialComparator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1744;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1803;
import net.minecraft.class_1812;
import net.minecraft.class_1825;
import net.minecraft.class_1828;
import net.minecraft.class_1831;
import net.minecraft.class_1833;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_4057;
import net.minecraft.class_4059;

public class ItemStackComparator
implements Comparator<class_1799> {
    private static final List<Comparator<class_1799>> SUB_COMPARATORS = List.of(Comparator.comparing(ItemStackComparator::getSortName), ConditionalComparator.comparing((T s) -> s.method_7909() instanceof class_1831, SerialComparator.comparing(Comparator.comparingInt(ItemStackComparator::getTieredItemDamage).reversed(), Comparator.comparingInt(ItemStackComparator::getTieredItemSpeed).reversed())), ConditionalComparator.comparing((T s) -> s.method_7909() instanceof class_1738, SerialComparator.comparing(Comparator.comparingInt(ItemStackComparator::getArmorSlot).reversed(), Comparator.comparingInt(ItemStackComparator::getArmorValue).reversed())), ConditionalComparator.comparing((T s) -> s.method_7909() instanceof class_4059, Comparator.comparingInt(ItemStackComparator::getHorseArmorValue).reversed()), ConditionalComparator.comparing((T s) -> !class_1844.method_8067((class_1799)s).isEmpty(), SerialComparator.comparing(Comparator.comparing(ItemStackComparator::getPotionEffectName), Comparator.comparingInt(ItemStackComparator::getPotionLevel).reversed(), Comparator.comparingInt(ItemStackComparator::getPotionLength).reversed())), Comparator.comparingInt(ItemStackComparator::getHasNameAsInt).reversed(), ConditionalComparator.comparing(class_1799::method_7938, Comparator.comparing(s -> s.method_7964().getString().toLowerCase(Locale.ROOT))), Comparator.comparingInt(ItemStackComparator::getIsEnchantedAsInt).reversed(), ConditionalComparator.comparing(ItemStackComparator::isEnchantedBookOrEnchantedItem, Comparator.comparing(ItemStackComparator::getEnchantmentListAsString)), Comparator.comparingInt(ItemStackComparator::getColor), Comparator.comparingInt(class_1799::method_7947).reversed(), Comparator.comparingInt(class_1799::method_7919), Comparator.comparing(s -> s.method_7964().getString().toLowerCase(Locale.ROOT)));
    private static final List<String> COMMON_SUFFIXES = List.of("log", "wood", "leaves", "planks", "sign", "pressure_plate", "button", "door", "trapdoor", "fence", "fence_gate", "stairs", "ore", "boat", "spawn_egg", "soup", "seeds", "banner_pattern", "book", "map", "golden_apple", "minecart", "rail", "piston", "coral", "coral_wall_fan", "coral_block", "ice");
    private static final List<String> COLOR_PREFIXES = Arrays.stream(class_1767.values()).map(class_1767::method_7792).collect(Collectors.toList());
    private static final List<class_3545<String, String>> REGEX_REPLACERS = List.of(new class_3545((Object)"^stripped_(.+?)_(log|wood)$", (Object)"$2_stripped_$1"), new class_3545((Object)"(.+?)_vertical_slab$", (Object)"slab_vertical_$1"), new class_3545((Object)"(.+?)_slab$", (Object)"slab_horizontal_$1"), new class_3545((Object)"^(.*?)concrete(?!_powder)(.*)$", (Object)"$1concrete_a$2"), new class_3545((Object)"^cooked_(.+)$", (Object)"$1_cooked"), new class_3545((Object)String.format("^(.+?)_(%s)$", String.join((CharSequence)"|", COMMON_SUFFIXES)), (Object)"$2_$1"), new class_3545((Object)String.format("^(%s)_(.+)$", String.join((CharSequence)"|", COLOR_PREFIXES)), (Object)"$2"));
    private final SerialComparator<class_1799> underlyingComparator;

    private ItemStackComparator(SerialComparator<class_1799> underlyingComparator) {
        this.underlyingComparator = underlyingComparator;
    }

    @Override
    public int compare(class_1799 o1, class_1799 o2) {
        return this.underlyingComparator.compare(o1, o2);
    }

    private static String getSortName(class_1799 itemStack) {
        class_2248 block;
        class_1792 item = itemStack.method_7909();
        String itemString = item.toString();
        if (item instanceof class_1812) {
            if (item instanceof class_1828) {
                return "potion_splash";
            }
            if (item instanceof class_1803) {
                return "potion_lingering";
            }
            return "potion";
        }
        if (item instanceof class_1744) {
            if (item instanceof class_1833) {
                return "arrow_tipped";
            }
            if (item instanceof class_1825) {
                return "arrow_spectral";
            }
            return "arrow";
        }
        if (item instanceof class_1747 && (block = ((class_1747)item).method_7711()) instanceof class_2356) {
            return "flower_" + itemString;
        }
        for (class_3545<String, String> regexReplacer : REGEX_REPLACERS) {
            itemString = itemString.replaceAll((String)regexReplacer.method_15442(), (String)regexReplacer.method_15441());
        }
        return itemString;
    }

    private static int getIsEnchantedAsInt(class_1799 itemStack) {
        return itemStack.method_7942() ? 1 : 0;
    }

    private static boolean isEnchantedBookOrEnchantedItem(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1772 || itemStack.method_7942();
    }

    private static String getEnchantmentListAsString(class_1799 itemStack) {
        return class_1890.method_8222((class_1799)itemStack).entrySet().stream().map(e -> ((class_1887)e.getKey()).method_8179(((Integer)e.getValue()).intValue()).getString()).collect(Collectors.joining(" "));
    }

    private static int getTieredItemDamage(class_1799 itemStack) {
        return (int)(((class_1831)itemStack.method_7909()).method_8022().method_8028() * 100.0f);
    }

    private static int getTieredItemSpeed(class_1799 itemStack) {
        return (int)(((class_1831)itemStack.method_7909()).method_8022().method_8027() * 100.0f);
    }

    private static int getArmorSlot(class_1799 itemStack) {
        class_1304 slotType = ((class_1738)itemStack.method_7909()).method_7685();
        int groupValue = slotType.method_5925() == class_1304.class_1305.field_6178 ? 10 : 0;
        return groupValue + slotType.method_5927();
    }

    private static int getArmorValue(class_1799 itemStack) {
        return ((class_1738)itemStack.method_7909()).method_7687();
    }

    private static int getHorseArmorValue(class_1799 itemStack) {
        return ((class_4059)itemStack.method_7909()).method_18455();
    }

    private static String getPotionEffectName(class_1799 itemStack) {
        return class_1844.method_8067((class_1799)itemStack).stream().map(class_1293::method_5579).map(class_1291::method_5560).map(class_2561::getString).min(Comparator.naturalOrder()).orElse("");
    }

    private static int getPotionLevel(class_1799 itemStack) {
        return class_1844.method_8067((class_1799)itemStack).stream().mapToInt(class_1293::method_5578).max().orElse(0);
    }

    private static int getPotionLength(class_1799 itemStack) {
        return class_1844.method_8067((class_1799)itemStack).stream().mapToInt(class_1293::method_5584).max().orElse(0);
    }

    private static int getColor(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_4057) {
            return ((class_4057)item).method_7800(itemStack);
        }
        String itemString = item.toString();
        return Arrays.stream(class_1767.values()).filter(dyeColor -> itemString.startsWith(dyeColor.method_7792())).mapToInt(class_1767::method_7789).map(i -> i + 1).findFirst().orElse(0);
    }

    private static int getHasNameAsInt(class_1799 itemStack) {
        return itemStack.method_7938() ? 1 : 0;
    }

    public static ItemStackComparator comparator() {
        return new ItemStackComparator(SerialComparator.comparing(SUB_COMPARATORS));
    }
}

