/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;

public class OwnerAttributeTransferPower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;
    private final boolean updateHealth;
    private class_1320 ownerAttribute;

    public OwnerAttributeTransferPower(PowerType<?> type, class_1309 entity, int tickRate, boolean updateHealth) {
        super(type, entity);
        this.setTicking(true);
        this.tickRate = tickRate;
        this.updateHealth = updateHealth;
    }

    public void setOwnerAttribute(class_1320 ownerAttribute) {
        this.ownerAttribute = ownerAttribute;
    }

    public OwnerAttributeTransferPower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void tick() {
        if (this.entity.field_6012 % this.tickRate == 0) {
            if (this.isActive()) {
                this.applyModifiers();
            } else {
                this.removeModifiers();
            }
        }
    }

    public void onRemoved() {
        this.removeModifiers();
    }

    private void applyModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.method_6063();
            double previousHealthPercent = (double)this.entity.method_6032() / previousMaxHealth;
            class_1309 owner = ((ISummon)this.entity).method_35057();
            if (owner != null && this.ownerAttribute != null) {
                class_1324 ownerAttributeInstance = owner.method_5996(this.ownerAttribute);
                if (ownerAttributeInstance != null) {
                    double ownerAttributeValue = ownerAttributeInstance.method_6194();
                    this.modifiers.forEach(mod -> {
                        class_1324 summonAttributeInstance = this.entity.method_5996(mod.getAttribute());
                        if (summonAttributeInstance != null) {
                            double finalModifierAmount = ownerAttributeValue * mod.getModifier().method_6186();
                            class_1322 newModifier = new class_1322(mod.getModifier().method_6189(), mod.getModifier().method_6185(), finalModifierAmount, mod.getModifier().method_6182());
                            if (!summonAttributeInstance.method_6196(newModifier)) {
                                summonAttributeInstance.method_26835(newModifier);
                            }
                        }
                    });
                }
                if (this.updateHealth) {
                    double afterMaxHealth = this.entity.method_6063();
                    this.entity.method_6033((float)(afterMaxHealth * previousHealthPercent));
                }
            }
        }
    }

    private void removeModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.method_6063();
            double previousHealthPercent = (double)this.entity.method_6032() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                class_1324 summonAttributeInstance = this.entity.method_5996(mod.getAttribute());
                if (summonAttributeInstance != null) {
                    summonAttributeInstance.method_6202(mod.getModifier());
                }
            });
            if (this.updateHealth) {
                double afterMaxHealth = this.entity.method_6063();
                this.entity.method_6033((float)(afterMaxHealth * previousHealthPercent));
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(MedievalOrigins.loc("owner_attribute_transfer"), new SerializableData().add("owner_attribute", SerializableDataTypes.ATTRIBUTE).add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("tick_rate", SerializableDataTypes.INT, (Object)20).add("update_health", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, entity) -> {
            OwnerAttributeTransferPower power = new OwnerAttributeTransferPower((PowerType<?>)type, (class_1309)entity, data.getInt("tick_rate"), data.getBoolean("update_health"));
            power.setOwnerAttribute((class_1320)data.get("owner_attribute"));
            if (data.isPresent("modifier")) {
                power.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition();
    }
}

