/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.ExcavatingRecipe;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class ExcavatingBlockEntityImpl<R extends ExcavatingRecipe>
extends ExcavatingBlockEntity<R> {
    protected FluidTank fluidTank = new FluidTank(1296000L){

        protected void onContentsChanged() {
            ExcavatingBlockEntityImpl.this.notifyUpdate();
        }
    };

    protected ExcavatingBlockEntityImpl(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.method_10562(this.getTankInName()));
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566(this.getTankInName(), (class_2520)this.fluidTank.writeToNBT(new class_2487()));
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.fluidInfo")));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (Storage)this.fluidTank);
        return true;
    }

    @Override
    public void addToGoggleTooltip(List<class_2561> tooltip, R rec) {
        if (!(((ExcavatingRecipe)rec).getDrillingFluid().getRequiredAmount() == 0L || ((ExcavatingRecipe)rec).getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= ((ExcavatingRecipe)rec).getDrillingFluid().getRequiredAmount())) {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.noFluid")));
        }
    }

    @Override
    protected boolean validateRecipe(R recipe) {
        return super.validateRecipe(recipe) && (((ExcavatingRecipe)recipe).getDrillingFluid().getRequiredAmount() == 0L || ((ExcavatingRecipe)recipe).getDrillingFluid().test(this.fluidTank.getFluid()));
    }

    @Override
    protected boolean canExtract() {
        return this.current.getDrillingFluid().getRequiredAmount() == 0L || this.current.getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= this.current.getDrillingFluid().getRequiredAmount();
    }

    @Override
    protected void onFinished() {
        if (this.current.getDrillingFluid().getRequiredAmount() != 0L) {
            try (Transaction t = Transaction.openOuter();){
                this.fluidTank.extract((FluidVariant)this.fluidTank.variant, this.current.getDrillingFluid().getRequiredAmount(), (TransactionContext)t);
                t.commit();
            }
        }
    }

    protected String getTankInName() {
        return "tank";
    }
}

