/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.core.particle;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.ladysnake.effective.cosmetics.EffectiveCosmetics;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

@Environment(value=EnvType.CLIENT)
public class FireflyParticle
extends LodestoneWorldParticle {
    protected static final float BLINK_STEP = 0.05f;
    protected float nextAlphaGoal = 0.0f;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;
    protected int maxHeight;
    private class_2338 lightTarget;

    public FireflyParticle(class_638 world, WorldParticleOptions data, FabricSpriteProviderImpl spriteSet, double x, double y, double z, double xd, double yd, double zd) {
        super(world, data, spriteSet, x, y, z, xd, yd, zd);
        this.field_3847 = ThreadLocalRandom.current().nextInt(400, 1201);
        this.maxHeight = 4;
        this.field_3841 = 0.0f;
        this.field_3862 = false;
    }

    public static boolean canFlyThroughBlock(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        return !blockState.method_26228((class_1922)world, blockPos) && blockState.method_26227().method_15769();
    }

    public void method_3070() {
        block14: {
            block13: {
                this.field_3858 = this.field_3874;
                this.field_3838 = this.field_3854;
                this.field_3856 = this.field_3871;
                if (!this.field_3851.method_8597().method_29960() && !EffectiveCosmetics.isNightTime((class_1937)this.field_3851) || this.field_3866++ >= this.field_3847) {
                    this.nextAlphaGoal = 0.0f;
                    if (this.field_3841 <= 0.01f) {
                        this.method_3085();
                    }
                }
                if (this.field_3841 > this.nextAlphaGoal - 0.05f && this.field_3841 < this.nextAlphaGoal + 0.05f) {
                    this.nextAlphaGoal = this.field_3840.method_43057();
                } else if (this.nextAlphaGoal > this.field_3841) {
                    this.field_3841 = Math.min(this.field_3841 + 0.05f, 1.0f);
                } else if (this.nextAlphaGoal < this.field_3841) {
                    this.field_3841 = Math.max(this.field_3841 - 0.05f, 0.0f);
                }
                if (this.field_3840.method_43048(20) == 0 || this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0) break block13;
                class_243 class_2432 = new class_243(this.field_3874, this.field_3854, this.field_3871);
                if (!(class_2432.method_1028(this.xTarget, this.yTarget, this.zTarget) < 9.0)) break block14;
            }
            this.selectBlockTarget();
        }
        class_243 targetVector = new class_243(this.xTarget - this.field_3874, this.yTarget - this.field_3854, this.zTarget - this.field_3871);
        double length = targetVector.method_1033();
        targetVector = targetVector.method_1021(0.1 / length);
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - 0.1), (double)this.field_3871);
        if (!FireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, blockPos, this.field_3851.method_8320(blockPos))) {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.05;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        } else {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.9 * this.field_3869 + 0.1 * targetVector.field_1351;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        }
        if (!class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871).equals((Object)this.getTargetPosition())) {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    private void selectBlockTarget() {
        if (this.lightTarget == null) {
            double groundLevel = 0.0;
            for (int i = 0; i < 20; ++i) {
                class_2680 checkedBlock;
                class_2338 checkedPos = class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - (double)i), (double)this.field_3871);
                if (FireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, checkedPos, checkedBlock = this.field_3851.method_8320(checkedPos))) {
                    groundLevel = this.field_3854 - (double)i;
                }
                if (groundLevel != 0.0) break;
            }
            this.xTarget = this.field_3874 + this.field_3840.method_43059() * 10.0;
            this.yTarget = Math.min(Math.max(this.field_3854 + this.field_3840.method_43059() * 2.0, groundLevel), groundLevel + (double)this.maxHeight);
            this.zTarget = this.field_3871 + this.field_3840.method_43059() * 10.0;
            class_2338 targetPos = class_2338.method_49637((double)this.xTarget, (double)this.yTarget, (double)this.zTarget);
            if (!FireflyParticle.canFlyThroughBlock((class_1937)this.field_3851, targetPos, this.field_3851.method_8320(targetPos))) {
                this.yTarget += 1.0;
            }
            this.lightTarget = this.getMostLitBlockAround();
        } else {
            this.xTarget = (double)this.lightTarget.method_10263() + this.field_3840.method_43059();
            this.yTarget = (double)this.lightTarget.method_10264() + this.field_3840.method_43059();
            this.zTarget = (double)this.lightTarget.method_10260() + this.field_3840.method_43059();
            this.lightTarget = this.field_3851.method_8314(class_1944.field_9282, class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)) > 0 && !this.field_3851.method_8530() ? this.getMostLitBlockAround() : null;
        }
    }

    public class_2338 getTargetPosition() {
        return class_2338.method_49637((double)this.xTarget, (double)(this.yTarget + 0.5), (double)this.zTarget);
    }

    private class_2338 getMostLitBlockAround() {
        HashMap<class_2338, Integer> randBlocks = new HashMap<class_2338, Integer>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 bp = class_2338.method_49637((double)(this.field_3874 + (double)x), (double)(this.field_3854 + (double)y), (double)(this.field_3871 + (double)z));
                    randBlocks.put(bp, this.field_3851.method_8314(class_1944.field_9282, bp));
                }
            }
        }
        for (int i = 0; i < 15; ++i) {
            class_2338 randBP = class_2338.method_49637((double)(this.field_3874 + this.field_3840.method_43059() * 10.0), (double)(this.field_3854 + this.field_3840.method_43059() * 10.0), (double)(this.field_3871 + this.field_3840.method_43059() * 10.0));
            randBlocks.put(randBP, this.field_3851.method_8314(class_1944.field_9282, randBP));
        }
        return (class_2338)((Map.Entry)randBlocks.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getKey();
    }
}

